/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.helper;

import com.dynious.soundscool.SoundsCool;
import com.dynious.soundscool.handler.NetworkHandler;
import com.dynious.soundscool.handler.SoundHandler;
import com.dynious.soundscool.network.packet.IPacket;
import com.dynious.soundscool.network.packet.SoundChunkPacket;
import com.dynious.soundscool.network.packet.SoundUploadedPacket;
import com.dynious.soundscool.sound.Sound;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;

public class NetworkHelper {
    public static final int PARTITION_SIZE = 10000;

    public static void sendPacketToPlayer(IPacket packet, EntityPlayer player) {
        SoundsCool.proxy.getChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        SoundsCool.proxy.getChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        SoundsCool.proxy.getChannel().writeOutbound(new Object[]{packet});
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientSoundUpload(Sound sound) {
        NetworkHelper.uploadSound(sound);
        NetworkHandler.uploadedSounds.add(new Sound(sound.getSoundName(), Minecraft.func_71410_x().field_71439_g.getDisplayName()));
    }

    public static void serverSoundUpload(Sound sound, EntityPlayer player) {
        SoundsCool.proxy.getChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        SoundsCool.proxy.getChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        NetworkHelper.uploadSound(sound);
    }

    private static void uploadSound(Sound sound) {
        byte[] soundBytes = NetworkHelper.convertFileToByteArr(sound.getSoundLocation());
        for (int i = 0; i < soundBytes.length; i += 10000) {
            byte[] bytes = ArrayUtils.subarray((byte[])soundBytes, (int)i, (int)(i + Math.min(10000, soundBytes.length - i)));
            SoundsCool.proxy.getChannel().writeOutbound(new Object[]{new SoundChunkPacket(sound.getSoundName(), bytes)});
        }
        String category = FMLCommonHandler.instance().getEffectiveSide().isClient() ? Minecraft.func_71410_x().field_71439_g.getDisplayName() : MinecraftServer.func_71276_C().func_71273_Y();
        SoundsCool.proxy.getChannel().writeOutbound(new Object[]{new SoundUploadedPacket(sound.getSoundName(), category)});
    }

    public static byte[] convertFileToByteArr(File file) {
        if (file != null && file.exists()) {
            try {
                return FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void createFileFromByteArr(byte[] byteFile, String category, String fileName) {
        if (byteFile != null && byteFile.length > 0 && !category.isEmpty() && !fileName.isEmpty()) {
            File file = new File(SoundHandler.getSoundsFolder().getAbsolutePath() + File.separator + category + File.separator + fileName);
            try {
                FileUtils.writeByteArrayToFile((File)file, (byte[])byteFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

