/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.client.gui;

import com.dynious.soundscool.SoundsCool;
import com.dynious.soundscool.client.audio.SoundPlayer;
import com.dynious.soundscool.client.gui.GuiLocalSoundsList;
import com.dynious.soundscool.client.gui.IListGui;
import com.dynious.soundscool.handler.NetworkHandler;
import com.dynious.soundscool.handler.SoundHandler;
import com.dynious.soundscool.helper.NetworkHelper;
import com.dynious.soundscool.network.packet.client.GetUploadedSoundsPacket;
import com.dynious.soundscool.network.packet.client.RemoveSoundPacket;
import com.dynious.soundscool.sound.Sound;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.io.FileUtils;

public class GuiSounds
extends GuiScreen
implements IListGui {
    private GuiLocalSoundsList soundsList;
    private int selected = -1;
    private Sound selectedSound;
    private JFileChooser fileChooser;
    private EntityPlayer player;
    private GuiButton uploadButton;
    private GuiButton playButton;

    public GuiSounds(EntityPlayer player) {
        this.player = player;
        this.fileChooser = new JFileChooser(Minecraft.func_71410_x().field_71412_D);
        this.fileChooser.setFileFilter(new FileNameExtensionFilter("Sound Files (.ogg, .wav, .mp3)", "ogg", "wav", "mp3"));
        SoundsCool.proxy.getChannel().writeOutbound(new Object[]{new GetUploadedSoundsPacket(player)});
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.soundsList = new GuiLocalSoundsList(this, 150);
        this.field_146292_n.add(new GuiButton(0, this.getWidth() / 2, this.getHeight() - 42, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(1, 10, this.getHeight() - 42, 150, 20, "Select File"));
        this.playButton = new GuiButton(2, this.getWidth() / 2, this.getHeight() - 102, "Play Sound");
        this.field_146292_n.add(this.playButton);
        this.playButton.field_146124_l = false;
        this.uploadButton = new GuiButton(3, this.getWidth() / 2, this.getHeight() - 72, "Upload");
        this.field_146292_n.add(this.uploadButton);
        this.uploadButton.field_146124_l = false;
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_73863_a(int p_571_1_, int p_571_2_, float p_571_3_) {
        try {
            this.soundsList.drawScreen(p_571_1_, p_571_2_, p_571_3_);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.func_73863_a(p_571_1_, p_571_2_, p_571_3_);
        if (this.selectedSound != null) {
            this.getFontRenderer().func_78276_b(this.selectedSound.getSoundName(), this.getWidth() / 2 + 100 - this.getFontRenderer().func_78256_a(this.selectedSound.getSoundName()) / 2, 30, 0xFFFFFF);
            boolean hasSound = NetworkHandler.hasServerSound(this.selectedSound.getSoundName());
            String uploaded = hasSound ? "Uploaded" : "Not uploaded";
            this.getFontRenderer().func_78276_b(uploaded, this.getWidth() / 2 + 100 - this.getFontRenderer().func_78256_a(uploaded) / 2, 60, hasSound ? 65280 : 0xFF0000);
            if (this.selectedSound.getCategory() != null) {
                this.getFontRenderer().func_78276_b(this.selectedSound.getCategory(), this.getWidth() / 2 + 100 - this.getFontRenderer().func_78256_a(this.selectedSound.getCategory()) / 2, 90, 0xFFFFFF);
            }
            if (this.selectedSound.getSoundLocation() != null) {
                String space = FileUtils.byteCountToDisplaySize((long)this.selectedSound.getSoundLocation().length());
                this.getFontRenderer().func_78276_b(space, this.getWidth() / 2 + 100 - this.getFontRenderer().func_78256_a(space) / 2, 120, 0xFFFFFF);
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    this.field_146297_k.func_147108_a(null);
                    this.field_146297_k.func_71381_h();
                    break;
                }
                case 1: {
                    int fcReturn = this.fileChooser.showOpenDialog(null);
                    if (fcReturn != 0) break;
                    this.selectSoundIndex(-1);
                    this.selectedSound = new Sound(this.fileChooser.getSelectedFile());
                    this.onSelectedSoundChanged();
                    break;
                }
                case 2: {
                    if (this.selectedSound == null) break;
                    SoundPlayer.playSound(this.selectedSound.getSoundLocation(), (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v);
                    break;
                }
                case 3: {
                    if (this.selectedSound == null) break;
                    if (!NetworkHandler.hasServerSound(this.selectedSound.getSoundName())) {
                        Sound sound = SoundHandler.setupSound(this.selectedSound.getSoundLocation());
                        NetworkHelper.clientSoundUpload(sound);
                        this.selectSoundIndex(-1);
                        break;
                    }
                    SoundsCool.proxy.getChannel().writeOutbound(new Object[]{new RemoveSoundPacket(this.selectedSound.getSoundName())});
                    SoundHandler.removeSound(this.selectedSound);
                    this.selectSoundIndex(-1);
                }
            }
        }
    }

    public void onSelectedSoundChanged() {
        if (this.selectedSound != null) {
            if (NetworkHandler.hasServerSound(this.selectedSound.getSoundName())) {
                if (this.selected == -1) {
                    this.selectSoundIndex(NetworkHandler.uploadedSounds.indexOf(NetworkHandler.getServerSound(this.selectedSound.getSoundName())));
                }
                this.uploadButton.field_146126_j = "Remove";
                this.uploadButton.field_146124_l = NetworkHandler.uploadedSounds.get(this.selected).getCategory().equals(this.player.getDisplayName());
            } else {
                this.uploadButton.field_146126_j = "Upload";
                this.uploadButton.field_146124_l = true;
            }
            this.playButton.field_146124_l = true;
        } else {
            this.uploadButton.field_146126_j = "Upload";
            this.uploadButton.field_146124_l = false;
            this.playButton.field_146124_l = false;
        }
    }

    @Override
    public Minecraft getMinecraftInstance() {
        return this.field_146297_k;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public void selectSoundIndex(int selected) {
        this.selected = selected;
        this.selectedSound = selected >= 0 && selected < SoundHandler.getSounds().size() ? SoundHandler.getSounds().get(selected) : null;
        this.onSelectedSoundChanged();
    }

    @Override
    public boolean soundIndexSelected(int var1) {
        return var1 == this.selected;
    }

    @Override
    public int getWidth() {
        return this.field_146294_l;
    }

    @Override
    public int getHeight() {
        return this.field_146295_m;
    }

    @Override
    public void drawBackground() {
        this.func_146276_q_();
    }

    public boolean func_73868_f() {
        return false;
    }
}

