/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.network.packet.client;

import com.dynious.soundscool.network.packet.IPacket;
import com.dynious.soundscool.tileentity.TileSoundPlayer;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class SoundPlayerSelectPacket
implements IPacket {
    int dimensionId;
    int x;
    int y;
    int z;
    String soundName;

    public SoundPlayerSelectPacket() {
    }

    public SoundPlayerSelectPacket(TileSoundPlayer tile) {
        this.dimensionId = tile.func_145831_w().field_73011_w.field_76574_g;
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
        this.soundName = tile.getSelectedSound().getSoundName();
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        TileEntity tile;
        this.dimensionId = bytes.readInt();
        this.x = bytes.readInt();
        this.y = bytes.readInt();
        this.z = bytes.readInt();
        WorldServer world = DimensionManager.getWorld((int)this.dimensionId);
        int soundNameLength = bytes.readInt();
        char[] soundNameCars = new char[soundNameLength];
        for (int i = 0; i < soundNameLength; ++i) {
            soundNameCars[i] = bytes.readChar();
        }
        this.soundName = String.valueOf(soundNameCars);
        if (world != null && (tile = world.func_147438_o(this.x, this.y, this.z)) != null && tile instanceof TileSoundPlayer) {
            ((TileSoundPlayer)tile).selectSound(this.soundName);
        }
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeInt(this.dimensionId);
        bytes.writeInt(this.x);
        bytes.writeInt(this.y);
        bytes.writeInt(this.z);
        bytes.writeInt(this.soundName.length());
        for (char c : this.soundName.toCharArray()) {
            bytes.writeChar((int)c);
        }
    }
}

