/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.client.gui;

import com.dynious.soundscool.SoundsCool;
import com.dynious.soundscool.client.gui.GuiRemoteSoundsList;
import com.dynious.soundscool.client.gui.IListGui;
import com.dynious.soundscool.handler.NetworkHandler;
import com.dynious.soundscool.handler.SoundHandler;
import com.dynious.soundscool.network.packet.client.GetUploadedSoundsPacket;
import com.dynious.soundscool.network.packet.client.SoundPlayerPlayPacket;
import com.dynious.soundscool.sound.Sound;
import com.dynious.soundscool.tileentity.TileSoundPlayer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.io.FileUtils;

@SideOnly(value=Side.CLIENT)
public class GuiSoundPlayer
extends GuiScreen
implements IListGui {
    private GuiRemoteSoundsList soundsList;
    private TileSoundPlayer tile;
    private GuiButton playButton;

    public GuiSoundPlayer(TileSoundPlayer tile) {
        this.tile = tile;
        SoundsCool.proxy.getChannel().writeOutbound(new Object[]{new GetUploadedSoundsPacket((EntityPlayer)Minecraft.func_71410_x().field_71439_g)});
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.soundsList = new GuiRemoteSoundsList(this, 150);
        this.field_146292_n.add(new GuiButton(0, this.getWidth() / 2, this.getHeight() - 42, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.playButton = new GuiButton(1, this.getWidth() / 2, this.getHeight() - 72, "Play");
        this.field_146292_n.add(this.playButton);
        this.onSelectedSoundChanged();
    }

    public void func_73863_a(int p_571_1_, int p_571_2_, float p_571_3_) {
        this.soundsList.drawScreen(p_571_1_, p_571_2_, p_571_3_);
        super.func_73863_a(p_571_1_, p_571_2_, p_571_3_);
        Sound sound = this.tile.getSelectedSound();
        if (sound != null) {
            this.getFontRenderer().func_78276_b(sound.getSoundName(), this.getWidth() / 2 + 100 - this.getFontRenderer().func_78256_a(sound.getSoundName()) / 2, 30, 0xFFFFFF);
            boolean hasSound = SoundHandler.getSound(sound.getSoundName()) != null;
            String uploaded = hasSound ? "Downloaded" : "Not downloaded";
            this.getFontRenderer().func_78276_b(uploaded, this.getWidth() / 2 + 100 - this.getFontRenderer().func_78256_a(uploaded) / 2, 60, hasSound ? 65280 : 0xFF0000);
            String category = NetworkHandler.getServerSound(sound.getSoundName()).getCategory();
            this.getFontRenderer().func_78276_b(category, this.getWidth() / 2 + 100 - this.getFontRenderer().func_78256_a(category) / 2, 90, 0xFFFFFF);
            if (sound.getSoundLocation() != null) {
                String space = FileUtils.byteCountToDisplaySize((long)sound.getSoundLocation().length());
                this.getFontRenderer().func_78276_b(space, this.getWidth() / 2 + 100 - this.getFontRenderer().func_78256_a(space) / 2, 120, 0xFFFFFF);
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    this.field_146297_k.func_147108_a(null);
                    this.field_146297_k.func_71381_h();
                    break;
                }
                case 1: {
                    if (this.tile.getSelectedSound() == null) break;
                    SoundsCool.proxy.getChannel().writeOutbound(new Object[]{new SoundPlayerPlayPacket(this.tile)});
                }
            }
        }
    }

    public void onSelectedSoundChanged() {
        this.playButton.field_146124_l = this.tile.getSelectedSound() != null;
    }

    @Override
    public Minecraft getMinecraftInstance() {
        return this.field_146297_k;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public void selectSoundIndex(int selected) {
        if (selected >= 0 && selected < NetworkHandler.uploadedSounds.size()) {
            this.tile.selectSound(NetworkHandler.uploadedSounds.get(selected).getSoundName());
            this.onSelectedSoundChanged();
        }
    }

    @Override
    public boolean soundIndexSelected(int var1) {
        Sound sound = this.tile.getSelectedSound();
        if (sound != null) {
            return NetworkHandler.uploadedSounds.indexOf(NetworkHandler.getServerSound(sound.getSoundName())) == var1;
        }
        return false;
    }

    @Override
    public int getWidth() {
        return this.field_146294_l;
    }

    @Override
    public int getHeight() {
        return this.field_146295_m;
    }

    @Override
    public void drawBackground() {
        this.func_146276_q_();
    }

    public boolean func_73868_f() {
        return false;
    }
}

