/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.network.packet;

import com.dynious.soundscool.handler.DelayedPlayHandler;
import com.dynious.soundscool.handler.NetworkHandler;
import com.dynious.soundscool.handler.SoundHandler;
import com.dynious.soundscool.helper.NetworkHelper;
import com.dynious.soundscool.network.packet.IPacket;
import io.netty.buffer.ByteBuf;

public class SoundUploadedPacket
implements IPacket {
    String category;
    String soundName;

    public SoundUploadedPacket() {
    }

    public SoundUploadedPacket(String soundName, String category) {
        this.category = category;
        this.soundName = soundName;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        int catLength = bytes.readInt();
        char[] catCars = new char[catLength];
        for (int i = 0; i < catLength; ++i) {
            catCars[i] = bytes.readChar();
        }
        this.category = String.valueOf(catCars);
        int fileLength = bytes.readInt();
        char[] fileCars = new char[fileLength];
        for (int i = 0; i < fileLength; ++i) {
            fileCars[i] = bytes.readChar();
        }
        this.soundName = String.valueOf(fileCars);
        NetworkHelper.createFileFromByteArr(NetworkHandler.soundUploaded(this.soundName), this.category, this.soundName);
        SoundHandler.findSounds();
        DelayedPlayHandler.onSoundReceived(this.soundName);
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeInt(this.category.length());
        for (char c : this.category.toCharArray()) {
            bytes.writeChar((int)c);
        }
        bytes.writeInt(this.soundName.length());
        for (char c : this.soundName.toCharArray()) {
            bytes.writeChar((int)c);
        }
    }
}

