/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common.network;

import atomicstryker.multimine.common.network.NetworkHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketDispatcher {
    private static NetworkHelper networkHelper;
    private static IPacketHandler clientPacketHandler;
    private static IPacketHandler serverPacketHandler;

    public static void init(String channel, IPacketHandler ch, IPacketHandler sh) {
        networkHelper = new NetworkHelper(channel, WrappedPacket.class);
        clientPacketHandler = ch;
        serverPacketHandler = sh;
    }

    public static void sendPacketToServer(WrappedPacket packet) {
        networkHelper.sendPacketToServer(packet);
    }

    public static void sendPacketToPlayer(WrappedPacket packet, EntityPlayer player) {
        networkHelper.sendPacketToPlayer(packet, player);
    }

    public static void sendPacketToAllInDimension(WrappedPacket packet, int dimension) {
        networkHelper.sendPacketToAllInDimension(packet, dimension);
    }

    public static void sendPacketToAllPlayers(WrappedPacket packet) {
        networkHelper.sendPacketToAllPlayers(packet);
    }

    public static void sendToAllNear(double posX, double posY, double posZ, double distance, int dimension, WrappedPacket packet) {
        networkHelper.sendPacketToAllAroundPoint(packet, new NetworkRegistry.TargetPoint(dimension, posX, posY, posZ, distance));
    }

    public static interface IPacketHandler {
        public void onPacketData(int var1, WrappedPacket var2, EntityPlayer var3);
    }

    public static class WrappedPacket
    implements NetworkHelper.IPacket {
        private int packetID;
        private Object[] toEncode;
        public ByteBuf data;

        public WrappedPacket() {
        }

        public WrappedPacket(int pID, Object[] toSend) {
            this.packetID = pID;
            this.toEncode = toSend;
        }

        public WrappedPacket(int pID, ByteBuf b) {
            this.packetID = pID;
            this.data = b;
        }

        @Override
        public void writeBytes(ChannelHandlerContext ctx, ByteBuf bytes) {
            bytes.writeInt(this.packetID);
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                this.writeStringToBuf(FMLClientHandler.instance().getClientPlayerEntity().func_70005_c_(), bytes);
            } else {
                this.writeStringToBuf("toServer", bytes);
            }
            if (this.data != null) {
                bytes.writeBytes(this.data);
            } else if (this.toEncode != null) {
                for (Object obj : this.toEncode) {
                    this.writeObjectToStream(obj, bytes);
                }
            }
        }

        private void writeObjectToStream(Object obj, ByteBuf data) {
            Class<?> objClass = obj.getClass();
            if (objClass.equals(Boolean.class)) {
                data.writeBoolean(((Boolean)obj).booleanValue());
            } else if (objClass.equals(Byte.class)) {
                data.writeByte((int)((Byte)obj).byteValue());
            } else if (objClass.equals(Integer.class)) {
                data.writeInt(((Integer)obj).intValue());
            } else if (objClass.equals(String.class)) {
                this.writeStringToBuf((String)obj, data);
            } else if (objClass.equals(Double.class)) {
                data.writeDouble(((Double)obj).doubleValue());
            } else if (objClass.equals(Float.class)) {
                data.writeFloat(((Float)obj).floatValue());
            } else if (objClass.equals(Long.class)) {
                data.writeLong(((Long)obj).longValue());
            } else if (objClass.equals(Short.class)) {
                data.writeShort((int)((Short)obj).shortValue());
            }
        }

        private void writeStringToBuf(String s, ByteBuf buf) {
            buf.writeShort(s.length());
            for (char c : s.toCharArray()) {
                buf.writeChar((int)c);
            }
        }

        @Override
        public void readBytes(ChannelHandlerContext ctx, ByteBuf bytes) {
            int pid = bytes.readInt();
            int len = bytes.readShort();
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = bytes.readChar();
            }
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                clientPacketHandler.onPacketData(pid, new WrappedPacket(pid, bytes), (EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
            } else {
                EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(String.valueOf(chars));
                if (player != null) {
                    serverPacketHandler.onPacketData(pid, new WrappedPacket(pid, bytes), (EntityPlayer)player);
                }
            }
        }
    }
}

