/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common;

import atomicstryker.multimine.client.ClientPacketHandler;
import atomicstryker.multimine.common.CommonProxy;
import atomicstryker.multimine.common.ServerPacketHandler;
import atomicstryker.multimine.common.network.PacketDispatcher;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameData;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="AS_MultiMine", name="Multi Mine", version="1.3.5")
public class MultiMine {
    private static MultiMine instance;
    private boolean blockRegenEnabled;
    private long initialBlockRegenDelay;
    private long blockRegenInterval;
    private String excludedBlocksString;
    private HashSet<Block> excludedBlockSet;
    private String excludedItemsString;
    private HashSet<Item> excludedItemSet;
    @SidedProxy(clientSide="atomicstryker.multimine.client.ClientProxy", serverSide="atomicstryker.multimine.common.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        instance = this;
        PacketDispatcher.init("AS_MM", new ClientPacketHandler(), new ServerPacketHandler());
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        this.blockRegenEnabled = config.get("general", "Block Regeneration Enabled", true).getBoolean(true);
        this.initialBlockRegenDelay = config.get("general", "Initial Block Regen Delay in ms", 5000).getInt();
        this.blockRegenInterval = config.get("general", "Block 10 percent Regen Interval in ms", 1000).getInt();
        this.excludedBlocksString = config.get("general", "Excluded Block IDs", "sapling,tallgrass,yellow_flower,red_flower,brown_mushroom,red_mushroom,torch,fire,redstone_wire,wheat,wooden_door,lever,unlit_redstone_torch,redstone_torch,reeds,unpowered_repeater,powered_repeater,trapdoor,pumpkin_stem,melon_stem,waterlily,tripwire_hook,tripwire,carrots,potatoes").getString();
        this.excludedItemsString = config.get("general", "Excluded Item IDs", "wooden_hoe,stone_hoe,iron_hoe,diamond_hoe,golden_hoe,shears").getString();
        config.save();
        this.excludedBlockSet = new HashSet();
        this.excludedItemSet = new HashSet();
        this.setExcludedBlocksString(this.excludedBlocksString);
        proxy.onPreInit();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        proxy.onLoad();
    }

    public static MultiMine instance() {
        return instance;
    }

    public boolean getBlockRegenEnabled() {
        return this.blockRegenEnabled;
    }

    public long getInitialBlockRegenDelay() {
        return this.initialBlockRegenDelay;
    }

    public long getBlockRegenInterval() {
        return this.blockRegenInterval;
    }

    public String getExcludedBlocksString() {
        return this.excludedBlocksString;
    }

    public String getExcludedItemssString() {
        return this.excludedItemsString;
    }

    public void setExcludedBlocksString(String input) {
        String[] numbers;
        this.excludedBlocksString = input.trim();
        for (String s : numbers = this.excludedBlocksString.split(",")) {
            Block b = (Block)GameData.blockRegistry.func_82594_a(s);
            if (b == Blocks.field_150350_a) continue;
            this.excludedBlockSet.add(b);
        }
    }

    public boolean getIsExcludedBlock(int blockID) {
        return this.excludedBlockSet.contains(blockID);
    }

    public void setExcludedItemssString(String input) {
        String[] numbers;
        this.excludedItemsString = input.trim();
        for (String s : numbers = this.excludedItemsString.split(",")) {
            Item it = (Item)GameData.itemRegistry.func_82594_a(s);
            if (it == null) continue;
            this.excludedItemSet.add(it);
        }
    }

    public boolean getIsExcludedItem(ItemStack itemStack) {
        return itemStack != null && this.excludedItemSet.contains(itemStack.func_77973_b());
    }
}

