/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.client;

import atomicstryker.multimine.common.MultiMine;
import atomicstryker.multimine.common.PartiallyMinedBlock;
import atomicstryker.multimine.common.network.ForgePacketWrapper;
import atomicstryker.multimine.common.network.PacketDispatcher;
import cpw.mods.fml.client.FMLClientHandler;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MultiMineClient {
    private static MultiMineClient instance;
    private static Minecraft mc;
    private static EntityPlayer thePlayer;
    private PartiallyMinedBlock[] partiallyMinedBlocksArray;
    private Map<Integer, DestroyBlockProgress> vanillaDestroyBlockProgressMap;
    private int arrayOverWriteIndex;
    private int curBlockX;
    private int curBlockY;
    private int curBlockZ;
    private float lastBlockCompletion;
    private int lastCloudTickReading;

    public MultiMineClient() {
        instance = this;
        mc = FMLClientHandler.instance().getClient();
        this.curBlockZ = 0;
        this.curBlockY = 0;
        this.curBlockX = 0;
        this.partiallyMinedBlocksArray = new PartiallyMinedBlock[30];
        this.arrayOverWriteIndex = 0;
        this.lastBlockCompletion = 0.0f;
        this.lastCloudTickReading = 0;
        System.out.println("Multi Mine about to hack vanilla RenderMap");
        for (Field f : RenderGlobal.class.getDeclaredFields()) {
            if (!f.getType().equals(Map.class)) continue;
            f.setAccessible(true);
            try {
                this.vanillaDestroyBlockProgressMap = (Map)f.get(MultiMineClient.mc.field_71438_f);
                System.out.println("Multi Mine vanilla RenderMap invasion successful, field: " + f.getName());
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static MultiMineClient instance() {
        return instance;
    }

    public float eventPlayerDamageBlock(int x, int y, int z, float blockCompletion) {
        thePlayer = FMLClientHandler.instance().getClient().field_71439_g;
        if (blockCompletion < 1.0f) {
            boolean override = false;
            for (int i = 0; i < this.partiallyMinedBlocksArray.length; ++i) {
                if (this.partiallyMinedBlocksArray[i] == null || this.partiallyMinedBlocksArray[i].getX() != x || this.partiallyMinedBlocksArray[i].getY() != y || this.partiallyMinedBlocksArray[i].getZ() != z) continue;
                float savedProgress = (float)this.partiallyMinedBlocksArray[i].getProgress() * 0.1f;
                if (!(savedProgress > blockCompletion)) break;
                blockCompletion = savedProgress;
                this.lastBlockCompletion = savedProgress;
                override = true;
                break;
            }
            if (!override) {
                if (blockCompletion > 0.99f) {
                    blockCompletion = 1.0f;
                }
                Object[] toSend = new Object[]{this.curBlockX, this.curBlockY, this.curBlockZ, MultiMineClient.thePlayer.field_71093_bK};
                if (this.curBlockX != x || this.curBlockY != y || this.curBlockZ != z) {
                    while (blockCompletion >= this.lastBlockCompletion + 0.1f) {
                        PacketDispatcher.sendPacketToServer(ForgePacketWrapper.createPacket("AS_MM", 1, toSend));
                        this.lastBlockCompletion += 0.1f;
                    }
                    this.curBlockX = x;
                    this.curBlockY = y;
                    this.curBlockZ = z;
                    this.lastBlockCompletion = 0.0f;
                } else if (blockCompletion + 0.1f >= this.lastBlockCompletion) {
                    while (blockCompletion >= this.lastBlockCompletion + 0.1f) {
                        PacketDispatcher.sendPacketToServer(ForgePacketWrapper.createPacket("AS_MM", 1, toSend));
                        this.lastBlockCompletion += 0.1f;
                    }
                }
            }
            if (blockCompletion == 1.0f) {
                this.lastBlockCompletion = 0.0f;
            }
        } else {
            this.lastBlockCompletion = 0.0f;
        }
        return blockCompletion;
    }

    public void renderBlockDigParticles(int x, int y, int z) {
        World world = MultiMineClient.thePlayer.field_70170_p;
        Block block = world.func_147439_a(x, y, z);
        if (block != Blocks.field_150350_a) {
            int blockMeta = world.func_72805_g(x, y, z);
            mc.func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation(block.field_149762_H.func_150495_a()), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f));
            MultiMineClient.mc.field_71452_i.func_147215_a(x, y, z, block, blockMeta);
        }
    }

    public boolean getIsEnabledForServerAndBlockId(int blockId) {
        return !MultiMineClient.thePlayer.field_71075_bZ.field_75098_d && !MultiMine.instance().getIsExcludedItem(thePlayer.func_71045_bC()) && !MultiMine.instance().getIsExcludedBlock(blockId);
    }

    public void onServerSentPartialBlockData(int x, int y, int z, int progress) {
        if (thePlayer == null) {
            return;
        }
        this.updateCloudTickReading();
        int dimension = MultiMineClient.thePlayer.field_71093_bK;
        PartiallyMinedBlock newBlock = new PartiallyMinedBlock(x, y, z, dimension, progress);
        int freeIndex = -1;
        for (int i = 0; i < this.partiallyMinedBlocksArray.length; ++i) {
            PartiallyMinedBlock iterBlock = this.partiallyMinedBlocksArray[i];
            if (iterBlock == null && freeIndex == -1) {
                freeIndex = i;
                continue;
            }
            if (!newBlock.equals(iterBlock)) continue;
            if (iterBlock.getProgress() < progress && (iterBlock.getX() != this.curBlockX || iterBlock.getY() != this.curBlockY || iterBlock.getZ() != this.curBlockZ)) {
                this.renderBlockDigParticles(x, y, z);
            }
            iterBlock.setProgress(progress);
            DestroyBlockProgress newDestroyBP = new DestroyBlockProgress(0, iterBlock.getX(), iterBlock.getY(), iterBlock.getZ());
            newDestroyBP.func_73107_a(iterBlock.getProgress());
            newDestroyBP.func_82744_b(this.lastCloudTickReading);
            this.vanillaDestroyBlockProgressMap.put(i, newDestroyBP);
            if (iterBlock.isFinished()) {
                EntityPlayer player = thePlayer;
                World w = player.field_70170_p;
                w.func_147443_d(player.func_145782_y(), x, y, z, -1);
                Block block = w.func_147439_a(x, y, z);
                if (block != Blocks.field_150350_a) {
                    int meta = w.func_72805_g(x, y, z);
                    if (block.removedByPlayer(w, player, x, y, z)) {
                        block.func_149664_b(w, x, y, z, meta);
                        block.func_149636_a(w, player, x, y, z, meta);
                    }
                    w.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.field_149762_H.func_150495_a(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f, false);
                }
                this.onBlockMineFinishedDamagePlayerItem(player, block, x, y, z);
                this.vanillaDestroyBlockProgressMap.remove(i);
                this.partiallyMinedBlocksArray[i] = null;
            }
            return;
        }
        if (freeIndex != -1) {
            this.partiallyMinedBlocksArray[freeIndex] = newBlock;
        } else {
            this.partiallyMinedBlocksArray[this.arrayOverWriteIndex++] = newBlock;
            if (this.arrayOverWriteIndex == this.partiallyMinedBlocksArray.length) {
                this.arrayOverWriteIndex = 0;
            }
        }
    }

    private void onBlockMineFinishedDamagePlayerItem(EntityPlayer player, Block blockID, int x, int y, int z) {
        if (x != this.curBlockX || y != this.curBlockY || z != this.curBlockZ) {
            return;
        }
        ItemStack itemStack = player.func_71045_bC();
        if (itemStack != null) {
            itemStack.func_150999_a(player.field_70170_p, blockID, x, y, z, player);
            if (itemStack.field_77994_a == 0) {
                player.func_71028_bD();
            }
        }
    }

    public void onServerSentPartialBlockDeleteCommand(int x, int y, int z) {
        for (int i = 0; i < this.partiallyMinedBlocksArray.length; ++i) {
            if (this.partiallyMinedBlocksArray[i] == null || this.partiallyMinedBlocksArray[i].getX() != x || this.partiallyMinedBlocksArray[i].getY() != y || this.partiallyMinedBlocksArray[i].getZ() != z) continue;
            this.partiallyMinedBlocksArray[i] = null;
            this.vanillaDestroyBlockProgressMap.remove(i);
            break;
        }
    }

    public void onServerSentExcludedBlocksList(String excludedBlocksString) {
        MultiMine.instance().setExcludedBlocksString(excludedBlocksString);
    }

    public void onServerSentExcludedItemsList(String excludedItemsString) {
        MultiMine.instance().setExcludedItemssString(excludedItemsString);
    }

    private void updateCloudTickReading() {
        DestroyBlockProgress dbp = this.vanillaDestroyBlockProgressMap.get(0);
        MultiMineClient.mc.field_71438_f.func_147587_b(0, (int)MultiMineClient.thePlayer.field_70165_t, (int)MultiMineClient.thePlayer.field_70163_u, (int)MultiMineClient.thePlayer.field_70161_v, 1);
        this.lastCloudTickReading = this.vanillaDestroyBlockProgressMap.get(0).func_82743_f();
        MultiMineClient.mc.field_71438_f.func_147587_b(0, (int)MultiMineClient.thePlayer.field_70165_t, (int)MultiMineClient.thePlayer.field_70163_u, (int)MultiMineClient.thePlayer.field_70161_v, 10);
        if (dbp != null) {
            this.vanillaDestroyBlockProgressMap.put(0, dbp);
        }
    }
}

