/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common.network;

import atomicstryker.multimine.common.network.PacketDispatcher;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;

public final class ForgePacketWrapper {
    public static PacketDispatcher.WrappedPacket createPacket(String channel, int packetID, Object[] input) {
        return new PacketDispatcher.WrappedPacket(packetID, input);
    }

    public static PacketDispatcher.WrappedPacket createPacket(int packetID, Object[] input) {
        return new PacketDispatcher.WrappedPacket(packetID, input);
    }

    public static Object[] readPacketData(ByteBuf data, Class<?>[] packetDataTypes) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Class<?> curClass : packetDataTypes) {
            result.add(ForgePacketWrapper.readObjectFromStream(data, curClass));
        }
        return result.toArray();
    }

    private static Object readObjectFromStream(ByteBuf data, Class<?> curClass) {
        if (curClass.equals(Boolean.class)) {
            return data.readBoolean();
        }
        if (curClass.equals(Byte.class)) {
            return data.readByte();
        }
        if (curClass.equals(Integer.class)) {
            return data.readInt();
        }
        if (curClass.equals(String.class)) {
            int len = data.readShort();
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = data.readChar();
            }
            return String.valueOf(chars);
        }
        if (curClass.equals(Double.class)) {
            return data.readDouble();
        }
        if (curClass.equals(Float.class)) {
            return Float.valueOf(data.readFloat());
        }
        if (curClass.equals(Long.class)) {
            return data.readLong();
        }
        if (curClass.equals(Short.class)) {
            return data.readShort();
        }
        return null;
    }
}

