/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common;

import atomicstryker.multimine.common.MultiMine;
import atomicstryker.multimine.common.PartiallyMinedBlock;
import atomicstryker.multimine.common.network.ForgePacketWrapper;
import atomicstryker.multimine.common.network.PacketDispatcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;

public class MultiMineServer {
    private static MultiMineServer instance;
    private static MinecraftServer serverInstance;
    private final HashMap<Integer, List<PartiallyMinedBlock>> partiallyMinedBlocksListByDimension = Maps.newHashMap();
    private final BlockRegenQueue blockRegenQueue;

    public MultiMineServer() {
        instance = this;
        this.blockRegenQueue = new BlockRegenQueue(30, new BlockAgeComparator());
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static MultiMineServer instance() {
        return instance;
    }

    public void onClientSentPartialBlockPacket(EntityPlayerMP player, int x, int y, int z, int dim) {
        serverInstance = FMLCommonHandler.instance().getMinecraftServerInstance();
        int dimension = player.field_71093_bK;
        ArrayList partiallyMinedBlocks = this.getPartiallyMinedBlocksForDimension(dimension);
        if (partiallyMinedBlocks == null) {
            partiallyMinedBlocks = Lists.newArrayList();
            this.partiallyMinedBlocksListByDimension.put(dimension, partiallyMinedBlocks);
        }
        PartiallyMinedBlock newblock = new PartiallyMinedBlock(x, y, z, dimension, 1);
        newblock.setLastTimeMined(System.currentTimeMillis() + MultiMine.instance().getInitialBlockRegenDelay());
        for (PartiallyMinedBlock iterBlock : partiallyMinedBlocks) {
            if (!iterBlock.equals(newblock)) continue;
            iterBlock.advanceProgress();
            iterBlock.setLastTimeMined(System.currentTimeMillis() + MultiMine.instance().getInitialBlockRegenDelay());
            this.sendPartiallyMinedBlockUpdateToAllPlayers(iterBlock);
            if (iterBlock.isFinished()) {
                player.field_70170_p.func_147443_d(player.func_145782_y(), x, y, z, -1);
                Block block = player.field_70170_p.func_147439_a(x, y, z);
                S23PacketBlockChange packet = new S23PacketBlockChange(x, y, z, player.field_70170_p);
                FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148537_a((Packet)packet, player.field_71093_bK);
                if (block != Blocks.field_150350_a) {
                    BlockEvent.BreakEvent event;
                    int meta = player.field_70170_p.func_72805_g(x, y, z);
                    if (block.removedByPlayer(player.field_70170_p, (EntityPlayer)player, x, y, z) && !(event = ForgeHooks.onBlockBreakEvent((World)player.field_70170_p, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z)).isCanceled()) {
                        block.func_149664_b(player.field_70170_p, x, y, z, meta);
                        this.onBlockMineFinishedDamagePlayerItem((EntityPlayer)player, block, x, y, z);
                        if (block.canHarvestBlock((EntityPlayer)player, meta)) {
                            block.func_149636_a(player.field_70170_p, (EntityPlayer)player, x, y, z, meta);
                        }
                    }
                }
                partiallyMinedBlocks.remove(iterBlock);
                this.blockRegenQueue.remove(iterBlock);
            }
            this.blockRegenQueue.offer(iterBlock);
            return;
        }
        if (partiallyMinedBlocks.size() > 29) {
            PartiallyMinedBlock old = (PartiallyMinedBlock)partiallyMinedBlocks.get(0);
            this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(old);
            partiallyMinedBlocks.remove(old);
            this.blockRegenQueue.remove(old);
        }
        partiallyMinedBlocks.add(newblock);
        this.blockRegenQueue.offer(newblock);
        this.sendPartiallyMinedBlockUpdateToAllPlayers(newblock);
    }

    private void onBlockMineFinishedDamagePlayerItem(EntityPlayer player, Block blockID, int x, int y, int z) {
        ItemStack itemStack = player.func_71045_bC();
        if (itemStack != null) {
            itemStack.func_150999_a(player.field_70170_p, blockID, x, y, z, player);
            if (itemStack.field_77994_a == 0) {
                player.func_71028_bD();
            }
        }
    }

    private void sendPartiallyMinedBlockDeleteCommandToAllPlayers(PartiallyMinedBlock block) {
        Object[] toSend = new Object[]{block.getX(), block.getY(), block.getZ(), block.getProgress()};
        PacketDispatcher.sendToAllNear(block.getX(), block.getY(), block.getZ(), 30.0, block.getDimension(), ForgePacketWrapper.createPacket("AS_MM", 2, toSend));
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        int dimension = player.field_70170_p.field_73011_w.field_76574_g;
        List<PartiallyMinedBlock> partiallyMinedBlocks = this.getPartiallyMinedBlocksForDimension(dimension);
        if (partiallyMinedBlocks != null) {
            for (PartiallyMinedBlock block : partiallyMinedBlocks) {
                this.sendPartiallyMinedBlockToPlayer(player, block);
            }
        }
        Object[] toSend = new Object[]{MultiMine.instance().getExcludedBlocksString()};
        PacketDispatcher.sendPacketToPlayer(ForgePacketWrapper.createPacket("AS_MM", 3, toSend), player);
        Object[] toSend2 = new Object[]{MultiMine.instance().getExcludedItemssString()};
        PacketDispatcher.sendPacketToPlayer(ForgePacketWrapper.createPacket("AS_MM", 4, toSend2), player);
    }

    private List<PartiallyMinedBlock> getPartiallyMinedBlocksForDimension(int dim) {
        return this.partiallyMinedBlocksListByDimension.get(dim);
    }

    private void sendPartiallyMinedBlockUpdateToAllPlayers(PartiallyMinedBlock block) {
        Object[] toSend = new Object[]{block.getX(), block.getY(), block.getZ(), block.getProgress()};
        PacketDispatcher.sendToAllNear(block.getX(), block.getY(), block.getZ(), 30.0, block.getDimension(), ForgePacketWrapper.createPacket("AS_MM", 1, toSend));
    }

    private void sendPartiallyMinedBlockToPlayer(EntityPlayer p, PartiallyMinedBlock block) {
        Object[] toSend = new Object[]{block.getX(), block.getY(), block.getZ(), block.getProgress()};
        PacketDispatcher.sendPacketToPlayer(ForgePacketWrapper.createPacket("AS_MM", 1, toSend), p);
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent tick) {
        if (tick.phase == TickEvent.Phase.END) {
            if (this.blockRegenQueue.isEmpty()) {
                return;
            }
            PartiallyMinedBlock block = null;
            Iterator iter = this.blockRegenQueue.iterator();
            while (iter.hasNext()) {
                block = (PartiallyMinedBlock)iter.next();
                if (!this.isBlockGone(block)) continue;
                this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(block);
                this.getPartiallyMinedBlocksForDimension(block.getDimension()).remove(block);
                iter.remove();
            }
            if (this.blockRegenQueue.isEmpty() || !MultiMine.instance().getBlockRegenEnabled()) {
                return;
            }
            long curTime = System.currentTimeMillis();
            if (((PartiallyMinedBlock)this.blockRegenQueue.peek()).getLastTimeMined() + MultiMine.instance().getBlockRegenInterval() < curTime) {
                block = (PartiallyMinedBlock)this.blockRegenQueue.poll();
                block.setProgress(block.getProgress() - 1);
                block.setLastTimeMined(curTime);
                if (block.getProgress() < 1) {
                    this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(block);
                    this.getPartiallyMinedBlocksForDimension(block.getDimension()).remove(block);
                } else {
                    this.sendPartiallyMinedBlockUpdateToAllPlayers(block);
                    this.blockRegenQueue.add(block);
                }
            }
        }
    }

    private boolean isBlockGone(PartiallyMinedBlock block) {
        return serverInstance.func_71218_a(block.getDimension()).func_147439_a(block.getX(), block.getY(), block.getZ()) == Blocks.field_150350_a;
    }

    private class BlockAgeComparator
    implements Comparator<PartiallyMinedBlock> {
        private BlockAgeComparator() {
        }

        @Override
        public int compare(PartiallyMinedBlock b1, PartiallyMinedBlock b2) {
            if (b1.getLastTimeMined() < b2.getLastTimeMined()) {
                return -1;
            }
            return 1;
        }
    }

    private class BlockRegenQueue
    extends PriorityQueue<PartiallyMinedBlock> {
        private static final long serialVersionUID = 1L;

        public BlockRegenQueue(int initialSize, Comparator<PartiallyMinedBlock> comparator) {
            super(initialSize, comparator);
        }

        @Override
        public boolean offer(PartiallyMinedBlock block) {
            if (this.contains(block)) {
                this.remove(block);
            }
            return super.offer(block);
        }
    }
}

