/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import universalelectricity.core.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;

public class PacketManager
implements IPacketHandler,
IPacketReceiver {
    public static dx getPacketWithID(String channelName, int id, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(id);
            data = PacketManager.encodeDataStream(data, sendData);
            da packet = new da();
            packet.a = channelName;
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static dx getPacket(String channelName, Object ... sendData) {
        return PacketManager.getPacketWithID(channelName, PacketType.UNSPECIFIED.ordinal(), sendData);
    }

    public static dx getPacket(String channelName, amm sender, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(PacketType.TILEENTITY.ordinal());
            data.writeInt(sender.l);
            data.writeInt(sender.m);
            data.writeInt(sender.n);
            data = PacketManager.encodeDataStream(data, sendData);
            da packet = new da();
            packet.a = channelName;
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static void sendPacketToClients(dx packet, xe worldObj, Vector3 position, double range) {
        try {
            PacketDispatcher.sendPacketToAllAround((double)position.x, (double)position.y, (double)position.z, (double)range, (int)worldObj.v.h, (dx)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(dx packet, xe worldObj) {
        try {
            PacketDispatcher.sendPacketToAllInDimension((dx)packet, (int)worldObj.v.h);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(dx packet) {
        try {
            if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
                FMLCommonHandler.instance().getMinecraftServerInstance().ad().a(packet);
            }
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static DataOutputStream encodeDataStream(DataOutputStream data, Object ... sendData) {
        try {
            for (Object dataValue : sendData) {
                if (dataValue instanceof Integer) {
                    data.writeInt((Integer)dataValue);
                    continue;
                }
                if (dataValue instanceof Float) {
                    data.writeFloat(((Float)dataValue).floatValue());
                    continue;
                }
                if (dataValue instanceof Double) {
                    data.writeDouble((Double)dataValue);
                    continue;
                }
                if (dataValue instanceof Byte) {
                    data.writeByte(((Byte)dataValue).byteValue());
                    continue;
                }
                if (dataValue instanceof Boolean) {
                    data.writeBoolean((Boolean)dataValue);
                    continue;
                }
                if (dataValue instanceof String) {
                    data.writeUTF((String)dataValue);
                    continue;
                }
                if (dataValue instanceof Short) {
                    data.writeShort(((Short)dataValue).shortValue());
                    continue;
                }
                if (!(dataValue instanceof Long)) continue;
                data.writeLong((Long)dataValue);
            }
            return data;
        }
        catch (IOException e) {
            System.out.println("Packet data encoding failed.");
            e.printStackTrace();
            return data;
        }
    }

    public void onPacketData(bv network, da packet, Player player) {
        try {
            ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.c);
            int packetTypeID = data.readInt();
            PacketType packetType = PacketType.get(packetTypeID);
            if (packetType == PacketType.TILEENTITY) {
                amm tileEntity;
                int x = data.readInt();
                int y = data.readInt();
                int z = data.readInt();
                xe world = ((qg)player).p;
                if (world != null && (tileEntity = world.p(x, y, z)) != null && tileEntity instanceof IPacketReceiver) {
                    ((IPacketReceiver)tileEntity).handlePacketData(network, packetTypeID, packet, (qg)player, data);
                }
            } else {
                this.handlePacketData(network, packetTypeID, packet, (qg)player, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handlePacketData(bv network, int packetType, da packet, qg player, ByteArrayDataInput dataStream) {
    }

    public static enum PacketType {
        UNSPECIFIED,
        TILEENTITY;


        public static PacketType get(int id) {
            if (id >= 0 && id < PacketType.values().length) {
                return PacketType.values()[id];
            }
            return UNSPECIFIED;
        }
    }
}

