/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.network;

import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import universalelectricity.prefab.network.ISimpleConnectionHandler;

public class ConnectionHandler
implements IConnectionHandler {
    private static final List simpleConnectionHandlers = new ArrayList();

    public static void registerConnectionHandler(ISimpleConnectionHandler tileEntity) {
        simpleConnectionHandlers.add(tileEntity);
    }

    public void playerLoggedIn(Player player, dy netHandler, bv manager) {
        for (ISimpleConnectionHandler handler : simpleConnectionHandlers) {
            handler.handelConnection(ConnectionType.LOGIN_SERVER, player, netHandler, manager);
        }
    }

    public void clientLoggedIn(dy clientHandler, bv manager, do login) {
        for (ISimpleConnectionHandler handler : simpleConnectionHandlers) {
            handler.handelConnection(ConnectionType.LOGIN_CLIENT, clientHandler, manager, login);
        }
    }

    public String connectionReceived(ik netHandler, bv manager) {
        for (ISimpleConnectionHandler handler : simpleConnectionHandlers) {
            handler.handelConnection(ConnectionType.RECEIVED, netHandler, manager);
        }
        return null;
    }

    public void connectionOpened(dy netClientHandler, String server, int port, bv manager) {
        for (ISimpleConnectionHandler handler : simpleConnectionHandlers) {
            handler.handelConnection(ConnectionType.OPEN_REMOTE, netClientHandler, server, port, manager);
        }
    }

    public void connectionOpened(dy netClientHandler, MinecraftServer server, bv manager) {
        for (ISimpleConnectionHandler handler : simpleConnectionHandlers) {
            handler.handelConnection(ConnectionType.OPEN_LOCAL, netClientHandler, server, manager);
        }
    }

    public void connectionClosed(bv manager) {
        for (ISimpleConnectionHandler handler : simpleConnectionHandlers) {
            handler.handelConnection(ConnectionType.CLOSED, manager);
        }
    }

    public static enum ConnectionType {
        LOGIN_SERVER,
        LOGIN_CLIENT,
        RECEIVED,
        OPEN_REMOTE,
        OPEN_LOCAL,
        CLOSED;

    }
}

