/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab;

import net.minecraftforge.common.ForgeDirection;
import universalelectricity.implement.IConnector;
import universalelectricity.prefab.Vector2;

public class Vector3
extends Vector2
implements Cloneable {
    public double z;
    public static final Vector3[] side = new Vector3[]{new Vector3(0, -1, 0), new Vector3(0, 1, 0), new Vector3(0, 0, -1), new Vector3(0, 0, 1), new Vector3(-1, 0, 0), new Vector3(1, 0, 0)};

    public Vector3() {
        this(0, 0, 0);
    }

    public Vector3(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public int intX() {
        return (int)Math.floor(this.x);
    }

    @Override
    public int intY() {
        return (int)Math.floor(this.y);
    }

    public int intZ() {
        return (int)Math.floor(this.z);
    }

    @Override
    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }

    public static Vector3 get(jn par1) {
        return new Vector3(par1.t, par1.u, par1.v);
    }

    public static Vector3 get(aji par1) {
        return new Vector3(par1.l, par1.m, par1.n);
    }

    public static Vector3 get(ajs par1) {
        return new Vector3(par1.a, par1.b, par1.c);
    }

    public static Vector3 get(ajq par1) {
        return new Vector3(par1.b, par1.c, par1.d);
    }

    public static Vector3 get(j par1) {
        return new Vector3(par1.a, par1.b, par1.c);
    }

    public int getBlockID(up world) {
        return world.a(this.intX(), this.intY(), this.intZ());
    }

    public int getBlockMetadata(up world) {
        return world.g(this.intX(), this.intY(), this.intZ());
    }

    public aji getTileEntity(up world) {
        return world.p(this.intX(), this.intY(), this.intZ());
    }

    public void setBlock(up world, int id, int metadata) {
        world.c(this.intX(), this.intY(), this.intZ(), id, metadata);
    }

    public void setBlock(up world, int id) {
        world.b(this.intX(), this.intY(), this.intZ(), id);
    }

    public void setBlockWithNotify(up world, int id, int metadata) {
        world.d(this.intX(), this.intY(), this.intZ(), id, metadata);
    }

    public void setBlockWithNotify(up world, int id) {
        world.e(this.intX(), this.intY(), this.intZ(), id);
    }

    public Vector2 toVector2() {
        return new Vector2(this.x, this.z);
    }

    public ajs toVec3() {
        return ajs.a((double)this.x, (double)this.y, (double)this.z);
    }

    public static boolean isPointInRegion(Vector3 point, Vector3 minPoint, Vector3 maxPoint) {
        return point.x > minPoint.x && point.x < maxPoint.x && point.y > minPoint.y && point.y < maxPoint.y && point.z > minPoint.z && point.z < maxPoint.z;
    }

    public boolean isEqual(Vector3 vector3) {
        return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
    }

    public static double distance(Vector3 par1, Vector3 par2) {
        double var2 = par1.x - par2.x;
        double var4 = par1.y - par2.y;
        double var6 = par1.z - par2.z;
        return ih.a((double)(var2 * var2 + var4 * var4 + var6 * var6));
    }

    public double distanceTo(Vector3 vector3) {
        double var2 = vector3.x - this.x;
        double var4 = vector3.y - this.y;
        double var6 = vector3.z - this.z;
        return ih.a((double)(var2 * var2 + var4 * var4 + var6 * var6));
    }

    public static Vector3 subtract(Vector3 par1, Vector3 par2) {
        return new Vector3(par1.x - par2.x, par1.y - par2.y, par1.z - par2.z);
    }

    public static Vector3 add(Vector3 par1, Vector3 par2) {
        return new Vector3(par1.x + par2.x, par1.y + par2.y, par1.z + par2.z);
    }

    public static Vector3 add(Vector3 par1, double par2) {
        return new Vector3(par1.x + par2, par1.y + par2, par1.z + par2);
    }

    public void add(Vector3 par1) {
        this.x += par1.x;
        this.y += par1.y;
        this.z += par1.z;
    }

    @Override
    public void add(double par1) {
        this.x += par1;
        this.y += par1;
        this.z += par1;
    }

    public static Vector3 multiply(Vector3 par1, Vector3 par2) {
        return new Vector3(par1.x * par2.x, par1.y * par2.y, par1.z * par2.z);
    }

    public static Vector3 multiply(Vector3 par1, double par2) {
        return new Vector3(par1.x * par2, par1.y * par2, par1.z * par2);
    }

    public static Vector3 readFromNBT(String prefix, an par1NBTTagCompound) {
        Vector3 tempVector = new Vector3();
        tempVector.x = par1NBTTagCompound.h(prefix + "X");
        tempVector.y = par1NBTTagCompound.h(prefix + "Y");
        tempVector.z = par1NBTTagCompound.h(prefix + "Z");
        return tempVector;
    }

    public void writeToNBT(String prefix, an par1NBTTagCompound) {
        par1NBTTagCompound.a(prefix + "X", this.x);
        par1NBTTagCompound.a(prefix + "Y", this.y);
        par1NBTTagCompound.a(prefix + "Z", this.z);
    }

    @Override
    public Vector3 round() {
        return new Vector3(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    @Override
    public Vector3 floor() {
        return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Vector3 top() {
        return Vector3.add(this, side[0]);
    }

    public Vector3 bottom() {
        return Vector3.add(this, side[1]);
    }

    public Vector3 front() {
        return Vector3.add(this, side[2]);
    }

    public Vector3 back() {
        return Vector3.add(this, side[3]);
    }

    public Vector3 left() {
        return Vector3.add(this, side[4]);
    }

    public Vector3 right() {
        return Vector3.add(this, side[5]);
    }

    @Override
    public String output() {
        return "Vector3: " + this.x + "," + this.y + "," + this.z;
    }

    public void modifyPositionFromSide(ForgeDirection side) {
        switch (side.ordinal()) {
            case 0: {
                this.y -= 1.0;
                break;
            }
            case 1: {
                this.y += 1.0;
                break;
            }
            case 2: {
                this.z -= 1.0;
                break;
            }
            case 3: {
                this.z += 1.0;
                break;
            }
            case 4: {
                this.x -= 1.0;
                break;
            }
            case 5: {
                this.x += 1.0;
            }
        }
    }

    public static aji getTileEntityFromSide(up world, Vector3 position, ForgeDirection side) {
        position.modifyPositionFromSide(side);
        return world.p(position.intX(), position.intY(), position.intZ());
    }

    public static aji getConnectorFromSide(up world, Vector3 position, ForgeDirection side) {
        aji tileEntity = Vector3.getTileEntityFromSide(world, position, side);
        if (tileEntity instanceof IConnector && ((IConnector)tileEntity).canConnect(Vector3.getOrientationFromSide(side, ForgeDirection.NORTH))) {
            return tileEntity;
        }
        return null;
    }

    public static ForgeDirection getOrientationFromSide(ForgeDirection front, ForgeDirection side) {
        switch (front.ordinal()) {
            case 0: {
                switch (side.ordinal()) {
                    case 0: {
                        return ForgeDirection.getOrientation((int)3);
                    }
                    case 1: {
                        return ForgeDirection.getOrientation((int)2);
                    }
                    case 2: {
                        return ForgeDirection.getOrientation((int)1);
                    }
                    case 3: {
                        return ForgeDirection.getOrientation((int)0);
                    }
                    case 4: {
                        return ForgeDirection.getOrientation((int)5);
                    }
                    case 5: {
                        return ForgeDirection.getOrientation((int)4);
                    }
                }
            }
            case 1: {
                switch (side.ordinal()) {
                    case 0: {
                        return ForgeDirection.getOrientation((int)4);
                    }
                    case 1: {
                        return ForgeDirection.getOrientation((int)5);
                    }
                    case 2: {
                        return ForgeDirection.getOrientation((int)0);
                    }
                    case 3: {
                        return ForgeDirection.getOrientation((int)1);
                    }
                    case 4: {
                        return ForgeDirection.getOrientation((int)2);
                    }
                    case 5: {
                        return ForgeDirection.getOrientation((int)3);
                    }
                }
            }
            case 2: {
                switch (side.ordinal()) {
                    case 0: {
                        return ForgeDirection.getOrientation((int)0);
                    }
                    case 1: {
                        return ForgeDirection.getOrientation((int)1);
                    }
                    case 2: {
                        return ForgeDirection.getOrientation((int)3);
                    }
                    case 3: {
                        return ForgeDirection.getOrientation((int)2);
                    }
                    case 4: {
                        return ForgeDirection.getOrientation((int)5);
                    }
                    case 5: {
                        return ForgeDirection.getOrientation((int)4);
                    }
                }
            }
            case 3: {
                return side;
            }
            case 4: {
                switch (side.ordinal()) {
                    case 0: {
                        return ForgeDirection.getOrientation((int)0);
                    }
                    case 1: {
                        return ForgeDirection.getOrientation((int)1);
                    }
                    case 2: {
                        return ForgeDirection.getOrientation((int)5);
                    }
                    case 3: {
                        return ForgeDirection.getOrientation((int)4);
                    }
                    case 4: {
                        return ForgeDirection.getOrientation((int)3);
                    }
                    case 5: {
                        return ForgeDirection.getOrientation((int)2);
                    }
                }
            }
            case 5: {
                switch (side.ordinal()) {
                    case 0: {
                        return ForgeDirection.getOrientation((int)0);
                    }
                    case 1: {
                        return ForgeDirection.getOrientation((int)1);
                    }
                    case 2: {
                        return ForgeDirection.getOrientation((int)4);
                    }
                    case 3: {
                        return ForgeDirection.getOrientation((int)5);
                    }
                    case 4: {
                        return ForgeDirection.getOrientation((int)2);
                    }
                    case 5: {
                        return ForgeDirection.getOrientation((int)3);
                    }
                }
            }
        }
        return ForgeDirection.UNKNOWN;
    }
}

