/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import universalelectricity.network.IPacketReceiver;
import universalelectricity.prefab.Vector3;

public class PacketManager
implements IPacketHandler,
IPacketReceiver {
    public static db getPacketWithID(String channelName, int id, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(id);
            data = PacketManager.encodeDataStream(data, sendData);
            ce packet = new ce();
            packet.a = channelName;
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static db getPacket(String channelName, Object ... sendData) {
        return PacketManager.getPacketWithID(channelName, PacketType.UNSPECIFIED.ordinal(), sendData);
    }

    public static db getPacket(String channelName, aji sender, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(PacketType.TILEENTITY.ordinal());
            data.writeInt(sender.l);
            data.writeInt(sender.m);
            data.writeInt(sender.n);
            data = PacketManager.encodeDataStream(data, sendData);
            ce packet = new ce();
            packet.a = channelName;
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static void sendPacketToClients(db packet, up worldObj, Vector3 position, double range) {
        try {
            PacketDispatcher.sendPacketToAllAround((double)position.x, (double)position.y, (double)position.z, (double)range, (int)worldObj.w.g, (db)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(db packet, up worldObj) {
        try {
            PacketDispatcher.sendPacketToAllInDimension((db)packet, (int)worldObj.w.g);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(db packet) {
        try {
            if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
                FMLCommonHandler.instance().getMinecraftServerInstance().ab().a(packet);
            }
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static DataOutputStream encodeDataStream(DataOutputStream data, Object ... sendData) {
        try {
            for (Object dataValue : sendData) {
                if (dataValue instanceof Integer) {
                    data.writeInt((Integer)dataValue);
                    continue;
                }
                if (dataValue instanceof Float) {
                    data.writeFloat(((Float)dataValue).floatValue());
                    continue;
                }
                if (dataValue instanceof Double) {
                    data.writeDouble((Double)dataValue);
                    continue;
                }
                if (dataValue instanceof Byte) {
                    data.writeByte(((Byte)dataValue).byteValue());
                    continue;
                }
                if (dataValue instanceof Boolean) {
                    data.writeBoolean((Boolean)dataValue);
                    continue;
                }
                if (dataValue instanceof String) {
                    data.writeUTF((String)dataValue);
                    continue;
                }
                if (dataValue instanceof Short) {
                    data.writeShort(((Short)dataValue).shortValue());
                    continue;
                }
                if (!(dataValue instanceof Long)) continue;
                data.writeLong((Long)dataValue);
            }
            return data;
        }
        catch (IOException e) {
            System.out.println("Packet data encoding failed.");
            e.printStackTrace();
            return data;
        }
    }

    public void onPacketData(az network, ce packet, Player player) {
        try {
            ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.c);
            int packetTypeID = data.readInt();
            PacketType packetType = PacketType.get(packetTypeID);
            if (packetType == PacketType.TILEENTITY) {
                aji tileEntity;
                int x = data.readInt();
                int y = data.readInt();
                int z = data.readInt();
                up world = ((og)player).p;
                if (world != null && (tileEntity = world.p(x, y, z)) != null && tileEntity instanceof IPacketReceiver) {
                    ((IPacketReceiver)tileEntity).handlePacketData(network, packetTypeID, packet, (og)player, data);
                }
            } else {
                this.handlePacketData(network, packetTypeID, packet, (og)player, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handlePacketData(az network, int packetType, ce packet, og player, ByteArrayDataInput dataStream) {
    }

    public static enum PacketType {
        UNSPECIFIED,
        TILEENTITY;


        public static PacketType get(int id) {
            if (id >= 0 && id < PacketType.values().length) {
                return PacketType.values()[id];
            }
            return UNSPECIFIED;
        }
    }
}

