/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.electricity;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.implement.IConductor;
import universalelectricity.implement.IElectricityReceiver;

public class ElectricityNetwork {
    public List conductors = new ArrayList();

    public ElectricityNetwork(IConductor conductor) {
        this.addConductor(conductor);
    }

    public void addConductor(IConductor newConductor) {
        this.cleanUpArray();
        if (!this.conductors.contains(newConductor)) {
            this.conductors.add(newConductor);
            newConductor.setNetwork(this);
        }
    }

    public List getConnectedReceivers() {
        this.cleanUpArray();
        ArrayList<IElectricityReceiver> returnArray = new ArrayList<IElectricityReceiver>();
        for (IConductor conductor : this.conductors) {
            for (int i = 0; i < conductor.getConnectedBlocks().length; i = (int)((byte)(i + 1))) {
                amm tileEntity = conductor.getConnectedBlocks()[i];
                if (tileEntity == null || !(tileEntity instanceof IElectricityReceiver) || returnArray.contains((IElectricityReceiver)tileEntity) || !((IElectricityReceiver)tileEntity).canReceiveFromSide(ForgeDirection.getOrientation((int)i).getOpposite())) continue;
                returnArray.add((IElectricityReceiver)tileEntity);
            }
        }
        return returnArray;
    }

    public void cleanUpArray() {
        for (int i = 0; i < this.conductors.size(); ++i) {
            if (this.conductors.get(i) == null) {
                this.conductors.remove(i);
                continue;
            }
            if (!((amm)this.conductors.get(i)).r()) continue;
            this.conductors.remove(i);
        }
    }

    public void setNetwork() {
        this.cleanUpArray();
        for (IConductor conductor : this.conductors) {
            conductor.setNetwork(this);
        }
    }

    public void onOverCharge() {
        this.cleanUpArray();
        for (int i = 0; i < this.conductors.size(); ++i) {
            ((IConductor)this.conductors.get(i)).onOverCharge();
        }
    }

    public double getLowestAmpConductor() {
        double lowestAmp = 0.0;
        for (IConductor conductor : this.conductors) {
            if (lowestAmp != 0.0 && !(conductor.getMaxAmps() < lowestAmp)) continue;
            lowestAmp = conductor.getMaxAmps();
        }
        return lowestAmp;
    }

    public void refreshConductors() {
        for (int j = 0; j < this.conductors.size(); ++j) {
            IConductor conductor = (IConductor)this.conductors.get(j);
            conductor.refreshConnectedBlocks();
        }
    }
}

