/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.electricity;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.TickType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.Vector3;
import universalelectricity.electricity.ElectricInfo;
import universalelectricity.electricity.ElectricityManagerTicker;
import universalelectricity.electricity.ElectricityNetwork;
import universalelectricity.electricity.ElectricityTransferData;
import universalelectricity.implement.IConductor;
import universalelectricity.implement.IElectricityReceiver;

public class ElectricityManager {
    public static ElectricityManager instance;
    private List electricityTransferQueue = new ArrayList();
    private List electricityNetworks = new ArrayList();

    public ElectricityManager() {
        System.out.println("Universal Electricity's Electricity Manager Initiated.");
    }

    public void registerConductor(IConductor newConductor) {
        this.cleanUpConnections();
        this.electricityNetworks.add(new ElectricityNetwork(newConductor));
    }

    public void mergeConnection(ElectricityNetwork networkA, ElectricityNetwork networkB) {
        if (networkA != networkB) {
            if (networkA != null && networkB != null) {
                networkA.conductors.addAll(networkB.conductors);
                networkA.setNetwork();
                this.electricityNetworks.remove(networkB);
                networkB = null;
            } else {
                System.err.println("Failed to merge Universal Electricity wire connections!");
            }
        }
    }

    public void splitConnection(IConductor conductorA, IConductor conductorB) {
        ElectricityNetwork connection = conductorA.getNetwork();
        if (connection != null) {
            connection.cleanUpArray();
            for (IConductor conductor : connection.conductors) {
                conductor.reset();
            }
            for (IConductor conductor : connection.conductors) {
                for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                    conductor.updateConnectionWithoutSplit(Vector3.getConnectorFromSide(conductor.getWorld(), new Vector3(((amm)conductor).l, ((amm)conductor).m, ((amm)conductor).n), ForgeDirection.getOrientation((int)i)), ForgeDirection.getOrientation((int)i));
                }
            }
        } else {
            FMLLog.severe((String)"Conductor invalid network while splitting connection!", (Object[])new Object[0]);
        }
    }

    public void cleanUpConnections() {
        try {
            for (int i = 0; i < this.electricityNetworks.size(); ++i) {
                ((ElectricityNetwork)this.electricityNetworks.get(i)).cleanUpArray();
                if (((ElectricityNetwork)this.electricityNetworks.get((int)i)).conductors.size() != 0) continue;
                this.electricityNetworks.remove(i);
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to clean up wire connections!", (Object[])new Object[0]);
        }
    }

    public void produceElectricity(amm sender, IConductor targetConductor, double amps, double voltage) {
        if (targetConductor != null && amps > 0.0 && voltage > 0.0) {
            ElectricityNetwork electricityNetwork = targetConductor.getNetwork();
            if (electricityNetwork != null) {
                List allElectricUnitsInLine = electricityNetwork.getConnectedReceivers();
                double leftOverAmps = amps;
                for (IConductor conductor : electricityNetwork.conductors) {
                    for (int i = 0; i < conductor.getConnectedBlocks().length; i = (int)((byte)(i + 1))) {
                        IElectricityReceiver receiver;
                        amm tileEntity = conductor.getConnectedBlocks()[i];
                        if (tileEntity == null || !(tileEntity instanceof IElectricityReceiver) || !(this.getActualWattRequest(receiver = (IElectricityReceiver)tileEntity) > 0.0) || !receiver.canReceiveFromSide(ForgeDirection.getOrientation((int)i).getOpposite())) continue;
                        double transferAmps = Math.max(0.0, Math.min(leftOverAmps, Math.min(amps / (double)allElectricUnitsInLine.size(), ElectricInfo.getAmps(this.getActualWattRequest(receiver), receiver.getVoltage()))));
                        leftOverAmps -= transferAmps;
                        double distance = Vector3.distance(Vector3.get(sender), Vector3.get((amm)receiver));
                        double ampsReceived = transferAmps - transferAmps * transferAmps * targetConductor.getResistance() * distance / voltage;
                        double voltsReceived = voltage - transferAmps * targetConductor.getResistance() * distance;
                        this.electricityTransferQueue.add(new ElectricityTransferData(sender, receiver, electricityNetwork, ForgeDirection.getOrientation((int)i).getOpposite(), ampsReceived, voltsReceived));
                    }
                }
            } else {
                FMLLog.severe((String)"Conductor not registered to a network!", (Object[])new Object[0]);
            }
        }
    }

    public double getActualWattRequest(IElectricityReceiver receiver) {
        double wattsRequest = receiver.wattRequest();
        try {
            for (int i = 0; i < this.electricityTransferQueue.size(); ++i) {
                if (this.electricityTransferQueue.get(i) == null || !((ElectricityTransferData)this.electricityTransferQueue.get(i)).isValid() || ((ElectricityTransferData)this.electricityTransferQueue.get((int)i)).receiver != receiver) continue;
                wattsRequest -= ((ElectricityTransferData)this.electricityTransferQueue.get((int)i)).amps * ((ElectricityTransferData)this.electricityTransferQueue.get((int)i)).voltage;
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to get watt request!", (Object[])new Object[0]);
        }
        return Math.max(Math.min(wattsRequest, receiver.wattRequest()), 0.0);
    }

    public double getElectricityRequired(ElectricityNetwork network) {
        double need = 0.0;
        if (network != null) {
            for (IConductor conductor : network.conductors) {
                for (int i = 0; i < conductor.getConnectedBlocks().length; i = (int)((byte)(i + 1))) {
                    IElectricityReceiver electricUnit;
                    amm tileEntity = conductor.getConnectedBlocks()[i];
                    if (tileEntity == null || !(tileEntity instanceof IElectricityReceiver) || !(electricUnit = (IElectricityReceiver)tileEntity).canReceiveFromSide(ForgeDirection.getOrientation((int)i).getOpposite())) continue;
                    need += electricUnit.wattRequest();
                }
            }
        }
        return need;
    }

    public double getActualElectricityRequired(ElectricityNetwork network) {
        double need = 0.0;
        if (network != null) {
            for (IConductor conductor : network.conductors) {
                for (int i = 0; i < conductor.getConnectedBlocks().length; i = (int)((byte)(i + 1))) {
                    IElectricityReceiver electricUnit;
                    amm tileEntity = conductor.getConnectedBlocks()[i];
                    if (tileEntity == null || !(tileEntity instanceof IElectricityReceiver) || !(electricUnit = (IElectricityReceiver)tileEntity).canReceiveFromSide(ForgeDirection.getOrientation((int)i).getOpposite())) continue;
                    need += this.getActualWattRequest(electricUnit);
                }
            }
        }
        return need;
    }

    public void refreshConductors() {
        try {
            Iterator it = this.electricityNetworks.iterator();
            while (it.hasNext()) {
                ((ElectricityNetwork)it.next()).refreshConductors();
            }
        }
        catch (Exception e) {
            FMLLog.fine((String)"Failed to refresh conductors.", (Object[])new Object[0]);
        }
    }

    public void onTick(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.WORLD) && !type.contains(TickType.WORLDLOAD)) {
            if (ElectricityManagerTicker.inGameTicks % 40L == 0L) {
                this.refreshConductors();
            }
            try {
                HashMap<ElectricityNetwork, Double> conductorAmpData = new HashMap<ElectricityNetwork, Double>();
                for (int i = 0; i < this.electricityTransferQueue.size(); ++i) {
                    if (this.electricityTransferQueue.get(i) != null && ((ElectricityTransferData)this.electricityTransferQueue.get(i)).isValid()) {
                        double amps = ((ElectricityTransferData)this.electricityTransferQueue.get((int)i)).amps;
                        if (conductorAmpData.containsKey(((ElectricityTransferData)this.electricityTransferQueue.get((int)i)).network)) {
                            amps += ((Double)conductorAmpData.get(((ElectricityTransferData)this.electricityTransferQueue.get((int)i)).network)).doubleValue();
                        }
                        conductorAmpData.put(((ElectricityTransferData)this.electricityTransferQueue.get((int)i)).network, amps);
                        ((ElectricityTransferData)this.electricityTransferQueue.get((int)i)).receiver.onReceive(((ElectricityTransferData)this.electricityTransferQueue.get((int)i)).sender, ((ElectricityTransferData)this.electricityTransferQueue.get((int)i)).amps, ((ElectricityTransferData)this.electricityTransferQueue.get((int)i)).voltage, ((ElectricityTransferData)this.electricityTransferQueue.get((int)i)).side);
                    }
                    this.electricityTransferQueue.remove(i);
                }
                Iterator it = conductorAmpData.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry pairs = it.next();
                    if (pairs.getKey() != null && pairs.getValue() != null && pairs.getKey() instanceof ElectricityNetwork && pairs.getValue() instanceof Double && (Double)pairs.getValue() > ((ElectricityNetwork)pairs.getKey()).getLowestAmpConductor()) {
                        ((ElectricityNetwork)pairs.getKey()).onOverCharge();
                    }
                    it.remove();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to transfer electricity to receivers.");
                e.printStackTrace();
            }
        }
        if (ElectricityManagerTicker.inGameTicks == 0L) {
            this.refreshConductors();
        }
    }
}

