/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.signals;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import railcraft.common.api.core.WorldCoordinate;
import railcraft.common.api.signals.IBlockSignal;
import railcraft.common.api.signals.ISignalController;
import railcraft.common.api.signals.ISignalReceiver;
import railcraft.common.api.tracks.RailTools;

public abstract class SignalTools {
    private static Map signalBlockPairingMap = new HashMap();
    private static Map controllerReceiverPairingMap = new HashMap();

    public static boolean isSignalBlockSectionValid(xe world, IBlockSignal first, IBlockSignal second) {
        return RailTools.areDistantRailsConnectedAlongAxis(world, first.getRailX(), first.getRailY(), first.getRailZ(), second.getRailX(), second.getRailY(), second.getRailZ());
    }

    public static boolean isControllerInRangeOfReceiver(ISignalController c, ISignalReceiver r2, int range) {
        int distZ;
        int distY;
        int distX = c.getX() - r2.getX();
        int distance = (int)Math.sqrt(distX * distX + (distY = c.getY() - r2.getY()) * distY + (distZ = c.getZ() - r2.getZ()) * distZ);
        return distance <= range;
    }

    public static void startSignalBlockPairing(qg player, tv device, IBlockSignal first) {
        SignalTools.endSignalBlockPairing(player, device);
        int id = new Random().nextInt(Short.MAX_VALUE);
        device.b(id);
        first.startSignalBlockPairing();
        signalBlockPairingMap.put(new PairingKey(player.bT, device.j()), new WorldCoordinate(first.getDimension(), first.getX(), first.getY(), first.getZ()));
    }

    public static WorldCoordinate getSignalBlockPair(qg player, tv device) {
        return (WorldCoordinate)signalBlockPairingMap.get(new PairingKey(player.bT, device.j()));
    }

    public static void endSignalBlockPairing(qg player, tv device) {
        amm t;
        WorldCoordinate pos = (WorldCoordinate)signalBlockPairingMap.remove(new PairingKey(player.bT, device.j()));
        if (pos != null && (t = player.p.p(pos.x, pos.y, pos.z)) instanceof IBlockSignal) {
            ((IBlockSignal)t).endSignalBlockPairing();
        }
    }

    public static void startControllerReceiverPairing(qg player, tv device, ISignalController controller) {
        SignalTools.endControllerReceiverPairing(player, device);
        int id = new Random().nextInt(Short.MAX_VALUE);
        device.b(id);
        controller.startReceiverPairing();
        controllerReceiverPairingMap.put(new PairingKey(player.bT, device.j()), new WorldCoordinate(controller.getDimension(), controller.getX(), controller.getY(), controller.getZ()));
    }

    public static WorldCoordinate getSavedController(qg player, tv device) {
        return (WorldCoordinate)controllerReceiverPairingMap.get(new PairingKey(player.bT, device.j()));
    }

    public static void endControllerReceiverPairing(qg player, tv device) {
        amm t;
        WorldCoordinate pos = (WorldCoordinate)controllerReceiverPairingMap.remove(new PairingKey(player.bT, device.j()));
        if (pos != null && (t = player.p.p(pos.x, pos.y, pos.z)) instanceof ISignalController) {
            ((ISignalController)t).endReceiverPairing();
        }
    }

    public static ISignalReceiver getReceiverFor(ISignalController con) {
        int k2;
        int j;
        xe world = con.getWorld();
        if (world == null || con.getReceiverY() < 0) {
            return null;
        }
        int i = con.getReceiverX();
        if (!world.e(i, j = con.getReceiverY(), k2 = con.getReceiverZ())) {
            return null;
        }
        amm pair = world.p(i, j, k2);
        if (pair instanceof ISignalReceiver) {
            return (ISignalReceiver)pair;
        }
        con.clearPairedReceiver();
        return null;
    }

    public static ISignalController getControllerFor(ISignalReceiver rec) {
        int k2;
        int j;
        if (rec.getControllerY() < 0) {
            return null;
        }
        xe world = rec.getWorld();
        if (world == null) {
            return null;
        }
        int i = rec.getControllerX();
        if (!world.e(i, j = rec.getControllerY(), k2 = rec.getControllerZ())) {
            return null;
        }
        amm pair = world.p(i, j, k2);
        if (pair instanceof ISignalController) {
            return (ISignalController)pair;
        }
        rec.clearPairedController();
        return null;
    }

    private static class PairingKey {
        protected String username;
        protected int id;

        public PairingKey(String username, int id) {
            this.username = username;
            this.id = id;
        }

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + (this.username != null ? this.username.hashCode() : 0);
            hash = 59 * hash + this.id;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PairingKey other = (PairingKey)obj;
            if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
                return false;
            }
            return this.id == other.id;
        }
    }
}

