/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.carts;

import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.carts.IItemTransfer;
import railcraft.common.api.carts.ILinkageManager;
import railcraft.common.api.carts.IMinecart;
import railcraft.common.api.core.items.IMinecartItem;

public abstract class CartTools {
    public static ILinkageManager serverLinkageManager;

    public static void registerMinecart(Object mod, Class type, String tag, int internalId) {
        EntityRegistry.registerModEntity((Class)type, (String)tag, (int)internalId, (Object)mod, (int)80, (int)3, (boolean)true);
    }

    public static ILinkageManager getLinkageManager(xe world) {
        return serverLinkageManager;
    }

    public static void setCartOwner(ph cart, qg owner) {
        cart.getEntityData().a("owner", owner.bT);
    }

    public static void setCartOwner(ph cart, String owner) {
        cart.getEntityData().a("owner", owner);
    }

    public static String getCartOwner(ph cart) {
        return cart.getEntityData().i("owner");
    }

    public static boolean doesCartMatchFilter(tv stack, ph cart) {
        if (stack == null) {
            return false;
        }
        if (cart instanceof IMinecart) {
            return ((IMinecart)cart).doesCartMatchFilter(stack, cart);
        }
        tv cartItem = cart.getCartItem();
        return cartItem != null && CartTools.isItemEqual(stack, cartItem);
    }

    private static boolean isItemEqual(tv a, tv b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.c != b.c) {
            return false;
        }
        if (a.d != null && !a.d.equals((Object)b.d)) {
            return false;
        }
        if (a.g() && (a.j() == -1 || b.j() == -1)) {
            return true;
        }
        return !a.g() || a.j() == b.j();
    }

    public static ph placeCart(String owner, tv cart, xe world, int i, int j, int k2) {
        if (cart == null) {
            return null;
        }
        if ((cart = cart.l()).b() instanceof IMinecartItem) {
            IMinecartItem mi = (IMinecartItem)cart.b();
            return mi.placeCart(owner, cart, world, i, j, k2);
        }
        if (cart.b() instanceof tz) {
            try {
                List carts;
                boolean placed = cart.b().a(cart, null, world, i, j, k2, 0, 0.0f, 0.0f, 0.0f);
                if (placed && (carts = CartTools.getMinecartsAt(world, i, j, k2, 0.3f)).size() > 0) {
                    CartTools.setCartOwner((ph)carts.get(0), owner);
                    return (ph)carts.get(0);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static void offerOrDropItem(ph cart, tv stack) {
        ph link_A = CartTools.getLinkageManager(cart.p).getLinkedCartA(cart);
        ph link_B = CartTools.getLinkageManager(cart.p).getLinkedCartB(cart);
        if (stack != null && stack.a > 0 && link_A instanceof IItemTransfer) {
            stack = ((IItemTransfer)link_A).offerItem(cart, stack);
        }
        if (stack != null && stack.a > 0 && link_B instanceof IItemTransfer) {
            stack = ((IItemTransfer)link_B).offerItem(cart, stack);
        }
        if (stack != null && stack.a > 0) {
            cart.a(stack, 1.0f);
        }
    }

    public static boolean isMinecartOnRailAt(xe world, int i, int j, int k2, float sensitivity) {
        return CartTools.isMinecartOnRailAt(world, i, j, k2, sensitivity, null, true);
    }

    public static boolean isMinecartOnRailAt(xe world, int i, int j, int k2, float sensitivity, Class type, boolean subclass) {
        if (akg.e_((xe)world, (int)i, (int)j, (int)k2)) {
            return CartTools.isMinecartAt(world, i, j, k2, sensitivity, type, subclass);
        }
        return false;
    }

    public static boolean isMinecartOnAnySide(xe world, int i, int j, int k2, float sensitivity) {
        return CartTools.isMinecartOnAnySide(world, i, j, k2, sensitivity, null, true);
    }

    public static boolean isMinecartOnAnySide(xe world, int i, int j, int k2, float sensitivity, Class type, boolean subclass) {
        ArrayList list = new ArrayList();
        for (int side = 0; side < 6; ++side) {
            list.addAll(CartTools.getMinecartsOnSide(world, i, j, k2, sensitivity, ForgeDirection.getOrientation((int)side)));
        }
        if (type == null) {
            return !list.isEmpty();
        }
        for (ph cart : list) {
            if ((!subclass || !type.isInstance(cart)) && cart.getClass() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isMinecartAt(xe world, int i, int j, int k2, float sensitivity) {
        return CartTools.isMinecartAt(world, i, j, k2, sensitivity, null, true);
    }

    public static boolean isMinecartAt(xe world, int i, int j, int k2, float sensitivity, Class type, boolean subclass) {
        List list = CartTools.getMinecartsAt(world, i, j, k2, sensitivity);
        if (type == null) {
            return !list.isEmpty();
        }
        for (ph cart : list) {
            if ((!subclass || !type.isInstance(cart)) && cart.getClass() != type) continue;
            return true;
        }
        return false;
    }

    public static List getMinecartsOnAllSides(xe world, int i, int j, int k2, float sensitivity) {
        ArrayList carts = new ArrayList();
        for (int side = 0; side < 6; ++side) {
            carts.addAll(CartTools.getMinecartsOnSide(world, i, j, k2, sensitivity, ForgeDirection.getOrientation((int)side)));
        }
        return carts;
    }

    public static List getMinecartsOnAllSides(xe world, int i, int j, int k2, float sensitivity, Class type, boolean subclass) {
        ArrayList list = new ArrayList();
        ArrayList<ph> carts = new ArrayList<ph>();
        for (int side = 0; side < 6; ++side) {
            list.addAll(CartTools.getMinecartsOnSide(world, i, j, k2, sensitivity, ForgeDirection.getOrientation((int)side)));
        }
        for (ph cart : list) {
            if ((!subclass || !type.isInstance(cart)) && cart.getClass() != type) continue;
            carts.add(cart);
        }
        return carts;
    }

    private static int getYOnSide(int y, ForgeDirection side) {
        switch (side) {
            case UP: {
                return y + 1;
            }
            case DOWN: {
                return y - 1;
            }
        }
        return y;
    }

    private static int getXOnSide(int x, ForgeDirection side) {
        switch (side) {
            case EAST: {
                return x + 1;
            }
            case WEST: {
                return x - 1;
            }
        }
        return x;
    }

    private static int getZOnSide(int z, ForgeDirection side) {
        switch (side) {
            case NORTH: {
                return z - 1;
            }
            case SOUTH: {
                return z + 1;
            }
        }
        return z;
    }

    public static List getMinecartsOnSide(xe world, int i, int j, int k2, float sensitivity, ForgeDirection side) {
        return CartTools.getMinecartsAt(world, CartTools.getXOnSide(i, side), CartTools.getYOnSide(j, side), CartTools.getZOnSide(k2, side), sensitivity);
    }

    public static boolean isMinecartOnSide(xe world, int i, int j, int k2, float sensitivity, ForgeDirection side) {
        return CartTools.getMinecartOnSide(world, i, j, k2, sensitivity, side) != null;
    }

    public static ph getMinecartOnSide(xe world, int i, int j, int k2, float sensitivity, ForgeDirection side) {
        Iterator i$ = CartTools.getMinecartsOnSide(world, i, j, k2, sensitivity, side).iterator();
        if (i$.hasNext()) {
            ph cart = (ph)i$.next();
            return cart;
        }
        return null;
    }

    public static boolean isMinecartOnSide(xe world, int i, int j, int k2, float sensitivity, ForgeDirection side, Class type, boolean subclass) {
        return CartTools.getMinecartOnSide(world, i, j, k2, sensitivity, side, type, subclass) != null;
    }

    public static ph getMinecartOnSide(xe world, int i, int j, int k2, float sensitivity, ForgeDirection side, Class type, boolean subclass) {
        for (ph cart : CartTools.getMinecartsOnSide(world, i, j, k2, sensitivity, side)) {
            if (type != null && (!subclass || !type.isInstance(cart)) && cart.getClass() != type) continue;
            return cart;
        }
        return null;
    }

    public static List getMinecartsAt(xe world, int i, int j, int k2, float sensitivity) {
        sensitivity = Math.min(sensitivity, 0.49f);
        List entities = world.a(ph.class, amr.a().a((double)((float)i + sensitivity), (double)((float)j + sensitivity), (double)((float)k2 + sensitivity), (double)((float)(i + 1) - sensitivity), (double)((float)(j + 1) - sensitivity), (double)((float)(k2 + 1) - sensitivity)));
        ArrayList<ph> carts = new ArrayList<ph>();
        for (Object o2 : entities) {
            carts.add((ph)o2);
        }
        return carts;
    }

    public static List getMinecartsIn(xe world, int i1, int j1, int k1, int i2, int j2, int k2) {
        List entities = world.a(ph.class, amr.a().a((double)i1, (double)j1, (double)k1, (double)i2, (double)j2, (double)k2));
        ArrayList<ph> carts = new ArrayList<ph>();
        for (Object o2 : entities) {
            carts.add((ph)o2);
        }
        return carts;
    }

    public static double getCartSpeedUncapped(ph cart) {
        return Math.sqrt(cart.w * cart.w + cart.y * cart.y);
    }

    public static boolean cartVelocityIsLessThan(ph cart, float vel) {
        return Math.abs(cart.w) < (double)vel && Math.abs(cart.y) < (double)vel;
    }
}

