/*
 * Decompiled with CFR 0.152.
 */
package net.uberkat.obsidian.common;

import buildcraft.api.core.Orientations;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.power.PowerProvider;
import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.ElectricItem;
import ic2.api.EnergyNet;
import ic2.api.IElectricItem;
import ic2.api.IEnergySink;
import ic2.api.IEnergySource;
import ic2.api.IEnergyStorage;
import ic2.api.IWrenchable;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.uberkat.obsidian.common.ObsidianIngots;
import net.uberkat.obsidian.common.PacketHandler;
import obsidian.api.IEnergizedItem;
import obsidian.api.IEnergyAcceptor;
import obsidian.api.ITileNetwork;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.Vector3;
import universalelectricity.electricity.ElectricInfo;
import universalelectricity.electricity.ElectricityManager;
import universalelectricity.implement.IConductor;
import universalelectricity.implement.IElectricityReceiver;
import universalelectricity.implement.IItemElectric;
import universalelectricity.implement.IJouleStorage;
import universalelectricity.prefab.TileEntityConductor;
import universalelectricity.prefab.TileEntityDisableable;

public class TileEntityPowerUnit
extends TileEntityDisableable
implements kl,
ISidedInventory,
ITileNetwork,
IWrenchable,
IEnergySink,
IEnergySource,
IEnergyStorage,
IPowerReceptor,
IJouleStorage,
IElectricityReceiver,
IEnergyAcceptor,
IPeripheral {
    public tv[] inventory = new tv[2];
    public int maxEnergy;
    public int output;
    public int energyStored = 0;
    public int facing;
    public int packetTick = 0;
    public IPowerProvider powerProvider;
    public boolean initialized = false;

    public TileEntityPowerUnit() {
        this(500000, 256);
    }

    public TileEntityPowerUnit(int energy, int i) {
        this.maxEnergy = energy;
        this.output = i;
        if (PowerFramework.currentFramework != null) {
            this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
            this.powerProvider.configure(5, 25, 25, 25, this.maxEnergy / 10);
        }
    }

    @Override
    public void g() {
        if (!this.k.J) {
            if (this.packetTick == 5) {
                PacketHandler.sendPowerUnitPacket(this);
            }
            ++this.packetTick;
        }
        if (!this.initialized) {
            if (ObsidianIngots.hooks.IC2Loaded) {
                EnergyNet.getForWorld(this.k).addTileEntity(this);
            }
            this.initialized = true;
        }
        if (this.powerProvider != null) {
            int received = (int)(this.powerProvider.useEnergy(25.0f, 25.0f, true) * 10.0f);
            this.setEnergy(this.energyStored + received);
        }
        if (this.inventory[0] != null && this.energyStored > 0) {
            if (this.inventory[0].b() instanceof IEnergizedItem) {
                IEnergizedItem item = (IEnergizedItem)this.inventory[0].b();
                int rejects = item.charge(this.inventory[0], item.getRate());
                this.setEnergy(this.energyStored - (item.getRate() - rejects));
            } else if (this.inventory[0].b() instanceof IItemElectric) {
                IItemElectric electricItem = (IItemElectric)this.inventory[0].b();
                double ampsToGive = Math.min(ElectricInfo.getAmps(electricItem.getMaxJoules() * 0.005, this.getVoltage()), (double)((float)this.energyStored * UniversalElectricity.IC2_RATIO));
                double joules = electricItem.onReceive(ampsToGive, this.getVoltage(), this.inventory[0]);
                this.setJoules((double)((float)this.energyStored * UniversalElectricity.IC2_RATIO) - (ElectricInfo.getJoules(ampsToGive, this.getVoltage(), 1.0) - joules), new Object[0]);
            } else if (this.inventory[0].b() instanceof IElectricItem) {
                int sent = ElectricItem.charge(this.inventory[0], this.energyStored, 3, false, false);
                this.setEnergy(this.energyStored - sent);
            }
        }
        if (this.inventory[1] != null && this.energyStored < this.maxEnergy) {
            if (this.inventory[1].b() instanceof IEnergizedItem) {
                IEnergizedItem item = (IEnergizedItem)this.inventory[1].b();
                int received = item.discharge(this.inventory[1], item.getRate());
                this.setEnergy(this.energyStored + received);
            } else if (this.inventory[1].b() instanceof IItemElectric) {
                IItemElectric electricItem = (IItemElectric)this.inventory[1].b();
                if (electricItem.canProduceElectricity()) {
                    double joulesReceived = electricItem.onUse(electricItem.getMaxJoules() * 0.005, this.inventory[1]);
                    this.setJoules((double)((float)this.energyStored * UniversalElectricity.IC2_RATIO) + joulesReceived, new Object[0]);
                }
            } else if (this.inventory[1].b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)this.inventory[1].b();
                if (item.canProvideEnergy()) {
                    int gain = ElectricItem.discharge(this.inventory[1], this.maxEnergy - this.energyStored, 3, false, false);
                    this.setEnergy(this.energyStored + gain);
                }
            } else if (this.inventory[1].c == tt.aC.cf) {
                this.setEnergy(this.energyStored + 1000);
                --this.inventory[1].a;
                if (this.inventory[1].a <= 0) {
                    this.inventory[1] = null;
                }
            }
        }
        if (this.energyStored > 0) {
            amm tileEntity = Vector3.getTileEntityFromSide(this.k, Vector3.get(this), ForgeDirection.getOrientation((int)this.facing));
            if (ObsidianIngots.hooks.IC2Loaded && this.energyStored >= this.output) {
                this.setEnergy(this.energyStored - (this.output - EnergyNet.getForWorld(this.k).emitEnergyFrom(this, this.output)));
            }
            if (tileEntity != null) {
                if (this.isPowerReceptor(tileEntity)) {
                    IPowerReceptor receptor = (IPowerReceptor)tileEntity;
                    int energyNeeded = Math.min(receptor.getPowerProvider().getMinEnergyReceived(), receptor.getPowerProvider().getMaxEnergyReceived()) * 10;
                    float transferEnergy = Math.max(Math.min(Math.min(energyNeeded, this.energyStored), 54000), 0);
                    receptor.getPowerProvider().receiveEnergy(transferEnergy / 10.0f, Orientations.dirs()[ForgeDirection.getOrientation((int)this.facing).getOpposite().ordinal()]);
                    this.setEnergy(this.energyStored - (int)transferEnergy);
                } else if (tileEntity instanceof TileEntityConductor) {
                    double joulesNeeded = ElectricityManager.instance.getElectricityRequired(((IConductor)tileEntity).getNetwork());
                    double transferAmps = Math.max(Math.min(Math.min(ElectricInfo.getAmps(joulesNeeded, this.getVoltage()), ElectricInfo.getAmps((float)this.energyStored * UniversalElectricity.IC2_RATIO, this.getVoltage())), 80.0), 0.0);
                    if (!this.k.J) {
                        ElectricityManager.instance.produceElectricity(this, (IConductor)tileEntity, transferAmps, this.getVoltage());
                    }
                    this.setEnergy(this.energyStored - (int)(ElectricInfo.getJoules(transferAmps, this.getVoltage()) * (double)UniversalElectricity.TO_IC2_RATIO));
                } else if (tileEntity instanceof IEnergyAcceptor && ((IEnergyAcceptor)tileEntity).canReceive(ForgeDirection.getOrientation((int)this.facing).getOpposite())) {
                    int sendingEnergy = 0;
                    if (this.energyStored >= this.output) {
                        sendingEnergy = this.output;
                    } else if (this.energyStored < this.output) {
                        sendingEnergy = this.energyStored;
                    }
                    int rejects = ((IEnergyAcceptor)tileEntity).transferToAcceptor(this.output);
                    this.setEnergy(this.energyStored - (sendingEnergy - rejects));
                }
            }
        }
        if (!this.k.J) {
            PacketHandler.sendPowerUnitPacketWithRange(this, 50.0);
        }
    }

    public void setEnergy(int energy) {
        this.energyStored = Math.max(Math.min(energy, this.maxEnergy), 0);
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    public int k_() {
        return this.inventory.length;
    }

    public tv a(int par1) {
        return this.inventory[par1];
    }

    public tv a(int par1, int par2) {
        if (this.inventory[par1] != null) {
            if (this.inventory[par1].a <= par2) {
                tv var3 = this.inventory[par1];
                this.inventory[par1] = null;
                return var3;
            }
            tv var3 = this.inventory[par1].a(par2);
            if (this.inventory[par1].a == 0) {
                this.inventory[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public tv a_(int par1) {
        if (this.inventory[par1] != null) {
            tv var2 = this.inventory[par1];
            this.inventory[par1] = null;
            return var2;
        }
        return null;
    }

    public void a(int par1, tv par2ItemStack) {
        this.inventory[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.a > this.c()) {
            par2ItemStack.a = this.c();
        }
    }

    public String b() {
        return this.output == 1024 ? "Advanced Power Unit" : "Power Unit";
    }

    public int c() {
        return 64;
    }

    public void l_() {
    }

    public void f() {
    }

    public void a(bh nbtTags) {
        super.a(nbtTags);
        if (PowerFramework.currentFramework != null) {
            PowerFramework.currentFramework.loadPowerProvider(this, nbtTags);
        }
        bp tagList = nbtTags.m("Items");
        this.inventory = new tv[this.k_()];
        for (int slots = 0; slots < tagList.c(); ++slots) {
            bh tagCompound = (bh)tagList.b(slots);
            byte slotID = tagCompound.c("Slot");
            if (slotID < 0 || slotID >= this.inventory.length) continue;
            this.inventory[slotID] = tv.a((bh)tagCompound);
        }
        this.energyStored = nbtTags.e("energyStored");
        this.facing = nbtTags.e("facing");
    }

    public void b(bh nbtTags) {
        super.b(nbtTags);
        if (PowerFramework.currentFramework != null) {
            PowerFramework.currentFramework.savePowerProvider(this, nbtTags);
        }
        nbtTags.a("energyStored", this.energyStored);
        nbtTags.a("facing", this.facing);
        bp tagList = new bp();
        for (int slots = 0; slots < this.inventory.length; ++slots) {
            if (this.inventory[slots] == null) continue;
            bh tagCompound = new bh();
            tagCompound.a("Slot", (byte)slots);
            this.inventory[slots].b(tagCompound);
            tagList.a((bu)tagCompound);
        }
        nbtTags.a("Items", (bu)tagList);
    }

    @Override
    public void handlePacketData(bv network, da packet, qg player, ByteArrayDataInput dataStream) {
        try {
            this.facing = dataStream.readInt();
            this.energyStored = dataStream.readInt();
            this.k.i(this.l, this.m, this.n);
        }
        catch (Exception e) {
            System.out.println("[ObsidianIngots] Error while handling tile entity packet.");
            e.printStackTrace();
        }
    }

    @Override
    public boolean wrenchCanSetFacing(qg entityPlayer, int side) {
        return this.facing != side;
    }

    @Override
    public short getFacing() {
        return (short)this.facing;
    }

    @Override
    public void setFacing(short direction) {
        if (this.initialized && ObsidianIngots.hooks.IC2Loaded) {
            EnergyNet.getForWorld(this.k).removeTileEntity(this);
        }
        this.initialized = false;
        this.facing = direction;
        PacketHandler.sendPowerUnitPacket(this);
        if (ObsidianIngots.hooks.IC2Loaded) {
            EnergyNet.getForWorld(this.k).addTileEntity(this);
        }
        this.initialized = true;
    }

    @Override
    public boolean wrenchCanRemove(qg entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public boolean acceptsEnergyFrom(amm emitter, Direction direction) {
        return direction.toForgeDirection() != ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.initialized;
    }

    @Override
    public int getStored() {
        return this.energyStored;
    }

    @Override
    public int getCapacity() {
        return this.maxEnergy;
    }

    @Override
    public int getRate() {
        return this.output;
    }

    @Override
    public boolean demandsEnergy() {
        return this.energyStored < this.maxEnergy;
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        int rejects = 0;
        int neededEnergy = this.maxEnergy - this.energyStored;
        if (i <= neededEnergy) {
            this.energyStored += i;
        } else if (i > neededEnergy) {
            this.energyStored += neededEnergy;
            rejects = i - neededEnergy;
        }
        return rejects;
    }

    @Override
    public boolean emitsEnergyTo(amm receiver, Direction direction) {
        return direction.toForgeDirection() == ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public int getMaxEnergyOutput() {
        return this.output;
    }

    @Override
    public double getJoules(Object ... data) {
        return (float)this.energyStored * UniversalElectricity.IC2_RATIO;
    }

    @Override
    public void setJoules(double joules, Object ... data) {
        this.setEnergy((int)(joules * (double)UniversalElectricity.TO_IC2_RATIO));
    }

    @Override
    public double getMaxJoules() {
        return (float)this.maxEnergy * UniversalElectricity.IC2_RATIO;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return true;
    }

    @Override
    public double getVoltage() {
        return 120.0;
    }

    public boolean isPowerReceptor(amm tileEntity) {
        if (tileEntity instanceof IPowerReceptor) {
            IPowerReceptor receptor = (IPowerReceptor)tileEntity;
            IPowerProvider provider = receptor.getPowerProvider();
            return provider != null && provider.getClass().getSuperclass().equals(PowerProvider.class);
        }
        return false;
    }

    @Override
    public void onReceive(amm sender, double amps, double voltage, ForgeDirection side) {
        this.setEnergy(this.energyStored + (int)(ElectricInfo.getJoules(amps, voltage) * (double)UniversalElectricity.TO_IC2_RATIO));
    }

    @Override
    public double wattRequest() {
        return ElectricInfo.getWatts((float)this.maxEnergy * UniversalElectricity.IC2_RATIO) - ElectricInfo.getWatts((float)this.energyStored * UniversalElectricity.IC2_RATIO);
    }

    @Override
    public boolean canReceiveFromSide(ForgeDirection side) {
        return side != ForgeDirection.getOrientation((int)this.facing);
    }

    public boolean a(qg entityplayer) {
        return this.k.p(this.l, this.m, this.n) != this ? false : entityplayer.e((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5) <= 64.0;
    }

    @Override
    public String getType() {
        return this.b();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.energyStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.maxEnergy};
            }
            case 3: {
                return new Object[]{this.maxEnergy - this.energyStored};
            }
        }
        System.err.println("[ObsidianIngots] Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer, String computerSide) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @Override
    public int transferToAcceptor(int amount) {
        int rejects = 0;
        int neededEnergy = this.maxEnergy - this.energyStored;
        if (amount <= neededEnergy) {
            this.energyStored += amount;
        } else if (amount > neededEnergy) {
            this.energyStored += neededEnergy;
            rejects = amount - neededEnergy;
        }
        return rejects;
    }

    @Override
    public boolean canReceive(ForgeDirection side) {
        return side != ForgeDirection.getOrientation((int)this.facing);
    }
}

