/*
 * Decompiled with CFR 0.152.
 */
package net.uberkat.obsidian.common;

import ic2.api.Ic2Recipes;
import net.uberkat.obsidian.common.ObsidianIngots;
import railcraft.common.api.core.items.ItemRegistry;

public class ObsidianHooks {
    private Class Ic2Items;
    private Class IC2;
    private Class Railcraft;
    private Class BCLoader;
    public tv IC2IronDust;
    public tv IC2GoldDust;
    public tv RailcraftObsidianDust;
    public boolean IC2Loaded = false;
    public boolean RailcraftLoaded = false;
    public boolean UELoaded = false;

    public void hook() {
        if (this.isIC2Installed()) {
            this.IC2Loaded = true;
        }
        if (this.isRailcraftInstalled()) {
            this.RailcraftLoaded = true;
        }
        if (this.isUEInstalled()) {
            this.UELoaded = true;
        }
        if (this.IC2Loaded) {
            this.IC2IronDust = this.getIC2Item("ironDust");
            this.IC2GoldDust = this.getIC2Item("goldDust");
            Ic2Recipes.addMaceratorRecipe(new tv(ObsidianIngots.OreBlock, 1, 0), new tv(ObsidianIngots.PlatinumDust, 2));
            Ic2Recipes.addMatterAmplifier(ObsidianIngots.EnrichedAlloy, 100000);
            System.out.println("[ObsidianIngots] Hooked into IC2 successfully.");
        }
        if (this.RailcraftLoaded) {
            this.RailcraftObsidianDust = this.getRailcraftItem("dust.obsidian");
            System.out.println("[ObsidianIngots] Hooked into Railcraft successfully.");
        }
    }

    public tv getIC2Item(String name) {
        try {
            Object ret;
            if (this.Ic2Items == null) {
                this.Ic2Items = Class.forName("ic2.common.Ic2Items");
            }
            if (this.Ic2Items == null) {
                this.Ic2Items = Class.forName("net.minecraft.src.ic2.common.Ic2Items");
            }
            if ((ret = this.Ic2Items.getField(name).get(null)) instanceof tv) {
                return (tv)ret;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("[ObsidianIngots] Unable to retrieve IC2 item " + name + ".");
            return null;
        }
    }

    public tv getRailcraftItem(String name) {
        return ItemRegistry.getItem(name, 1);
    }

    public boolean isIC2Installed() {
        try {
            Object ret;
            if (this.IC2 == null) {
                this.IC2 = Class.forName("ic2.common.IC2");
            }
            if (this.IC2 == null) {
                this.IC2 = Class.forName("net.minecraft.src.ic2.common.IC2");
            }
            return (ret = this.IC2.getField("platform").get(null)) != null;
        }
        catch (Exception e) {
            System.out.println("[ObsidianIngots] Unable to hook into IC2.");
            return false;
        }
    }

    public boolean isRailcraftInstalled() {
        try {
            Object ret;
            if (this.Railcraft == null) {
                this.Railcraft = Class.forName("railcraft.common.core.Railcraft");
            }
            return (ret = this.Railcraft.getField("instance").get(null)) != null;
        }
        catch (Exception e) {
            System.out.println("[ObsidianIngots] Unable to hook into Railcraft.");
            return false;
        }
    }

    public boolean isUEInstalled() {
        try {
            Object ret;
            if (this.BCLoader == null) {
                this.BCLoader = Class.forName("basiccomponents.BasicComponents");
            }
            return (ret = this.BCLoader.getField("instance").get(null)) != null;
        }
        catch (Exception e) {
            System.out.println("[ObsidianIngots] Unable to hook into UniversalElectricity.");
            return false;
        }
    }
}

