/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.recipes;

import buildcraft.api.liquids.LiquidStack;
import java.util.LinkedList;

public class RefineryRecipe {
    private static LinkedList recipes = new LinkedList();
    public final LiquidStack ingredient1;
    public final LiquidStack ingredient2;
    public final LiquidStack result;
    public final int energy;
    public final int delay;

    public static void registerRefineryRecipe(RefineryRecipe recipe) {
        if (!recipes.contains(recipe)) {
            recipes.add(recipe);
        }
    }

    public static RefineryRecipe findRefineryRecipe(LiquidStack liquid1, LiquidStack liquid2) {
        for (RefineryRecipe recipe : recipes) {
            if (!recipe.matches(liquid1, liquid2)) continue;
            return recipe;
        }
        return null;
    }

    public RefineryRecipe(int ingredientId1, int ingredientQty1, int ingredientId2, int ingredientQty2, int resultId, int resultQty, int energy, int delay) {
        this(new LiquidStack(ingredientId1, ingredientQty1, 0), new LiquidStack(ingredientId2, ingredientQty2, 0), new LiquidStack(resultId, resultQty, 0), energy, delay);
    }

    public RefineryRecipe(LiquidStack ingredient1, LiquidStack ingredient2, LiquidStack result, int energy, int delay) {
        this.ingredient1 = ingredient1;
        this.ingredient2 = ingredient2;
        this.result = result;
        this.energy = energy;
        this.delay = delay;
    }

    public boolean matches(LiquidStack liquid1, LiquidStack liquid2) {
        if (liquid1 == null && liquid2 == null) {
            return false;
        }
        if (this.ingredient1 != null && this.ingredient2 != null && (liquid1 == null || liquid2 == null)) {
            return false;
        }
        if (this.ingredient1 != null) {
            if (this.ingredient2 == null) {
                return this.ingredient1.isLiquidEqual(liquid1) || this.ingredient1.isLiquidEqual(liquid2);
            }
            return this.ingredient1.isLiquidEqual(liquid1) && this.ingredient2.isLiquidEqual(liquid2) || this.ingredient2.isLiquidEqual(liquid1) && this.ingredient1.isLiquidEqual(liquid2);
        }
        if (this.ingredient2 != null) {
            return this.ingredient2.isLiquidEqual(liquid1) || this.ingredient2.isLiquidEqual(liquid2);
        }
        return false;
    }
}

