/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.liquids;

public class LiquidStack {
    public int itemID;
    public int amount;
    public int itemMeta;

    private LiquidStack() {
    }

    public LiquidStack(int itemID, int amount) {
        this(itemID, amount, 0);
    }

    public LiquidStack(tt item, int amount) {
        this(item.cf, amount, 0);
    }

    public LiquidStack(alf block, int amount) {
        this(block.cm, amount, 0);
    }

    public LiquidStack(int itemID, int amount, int itemDamage) {
        this.itemID = itemID;
        this.amount = amount;
        this.itemMeta = itemDamage;
    }

    public bh writeToNBT(bh nbttagcompound) {
        nbttagcompound.a("Id", (short)this.itemID);
        nbttagcompound.a("Amount", this.amount);
        nbttagcompound.a("Meta", (short)this.itemMeta);
        return nbttagcompound;
    }

    public void readFromNBT(bh nbttagcompound) {
        this.itemID = nbttagcompound.d("Id");
        this.amount = nbttagcompound.e("Amount");
        this.itemMeta = nbttagcompound.d("Meta");
    }

    public LiquidStack copy() {
        return new LiquidStack(this.itemID, this.amount, this.itemMeta);
    }

    public boolean isLiquidEqual(LiquidStack other) {
        if (other == null) {
            return false;
        }
        return this.itemID == other.itemID && this.itemMeta == other.itemMeta;
    }

    public boolean containsLiquid(LiquidStack other) {
        if (!this.isLiquidEqual(other)) {
            return false;
        }
        return this.amount >= other.amount;
    }

    public boolean isLiquidEqual(tv other) {
        if (other == null) {
            return false;
        }
        return this.itemID == other.c && this.itemMeta == other.j();
    }

    public tv asItemStack() {
        return new tv(this.itemID, 1, this.itemMeta);
    }

    public static LiquidStack loadLiquidStackFromNBT(bh nbttagcompound) {
        LiquidStack liquidstack = new LiquidStack();
        liquidstack.readFromNBT(nbttagcompound);
        return liquidstack.itemID == 0 ? null : liquidstack;
    }
}

