/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.liquids;

import buildcraft.api.liquids.LiquidData;
import buildcraft.api.liquids.LiquidStack;
import java.util.LinkedList;

public class LiquidManager {
    public static final int BUCKET_VOLUME = 1000;
    public static LinkedList liquids = new LinkedList();

    public static LiquidStack getLiquidForFilledItem(tv filledItem) {
        if (filledItem == null) {
            return null;
        }
        for (LiquidData liquid : liquids) {
            if (!liquid.filled.a(filledItem)) continue;
            return liquid.stillLiquid;
        }
        return null;
    }

    public static int getLiquidIDForFilledItem(tv filledItem) {
        LiquidStack liquidForFilledItem = LiquidManager.getLiquidForFilledItem(filledItem);
        if (liquidForFilledItem == null) {
            return 0;
        }
        return liquidForFilledItem.itemID;
    }

    public static tv getFilledItemForLiquid(LiquidStack liquid) {
        for (LiquidData data : liquids) {
            if (!data.stillLiquid.isLiquidEqual(liquid)) continue;
            return data.filled.l();
        }
        return null;
    }

    public static tv fillLiquidContainer(int liquidId, int quantity, tv emptyContainer) {
        return LiquidManager.fillLiquidContainer(new LiquidStack(liquidId, quantity, 0), emptyContainer);
    }

    public static tv fillLiquidContainer(LiquidStack liquid, tv emptyContainer) {
        for (LiquidData data : liquids) {
            if (!liquid.containsLiquid(data.stillLiquid) || !data.container.a(emptyContainer)) continue;
            return data.filled.l();
        }
        return null;
    }

    public static boolean isLiquid(tv block) {
        if (block.c == 0) {
            return false;
        }
        for (LiquidData liquid : liquids) {
            if (!liquid.stillLiquid.isLiquidEqual(block) && !liquid.movingLiquid.isLiquidEqual(block)) continue;
            return true;
        }
        return false;
    }
}

