/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import universalelectricity.UEConfig;
import universalelectricity.recipe.CraftingRecipe;
import universalelectricity.recipe.IRecipeHandler;
import universalelectricity.recipe.SmeltingRecipe;

public class RecipeManager {
    private static final List SHAPED_RECIPES = new ArrayList();
    private static final List SHAPELESS_RECIPES = new ArrayList();
    private static final List SMELTING_RECIPES = new ArrayList();
    private static final Map RECIPE_HANDLERS = new HashMap();

    public static void addRecipe(rj output, Object[] input) {
        SHAPED_RECIPES.add(new CraftingRecipe(output, input));
    }

    public static void addRecipe(rh output, Object[] input) {
        RecipeManager.addRecipe(new rj(output), input);
    }

    public static void addRecipe(aig output, Object[] input) {
        RecipeManager.addRecipe(new rj(output), input);
    }

    public static void addRecipe(rj output, Object[] input, String name, Configuration config, boolean defaultBoolean) {
        if (config != null && UEConfig.getConfigData(config, "Allow " + name + " Crafting", defaultBoolean)) {
            RecipeManager.addRecipe(output, input);
        }
    }

    public static void addRecipe(rj output, Object[] input, Configuration config, boolean defaultBoolean) {
        RecipeManager.addRecipe(output, input, output.a(), config, defaultBoolean);
    }

    public static List getRecipes() {
        return SHAPED_RECIPES;
    }

    public static CraftingRecipe getRecipeByOutput(rj output) {
        for (CraftingRecipe recipe : SHAPED_RECIPES) {
            if (recipe.output != output) continue;
            return recipe;
        }
        return null;
    }

    public static void addShapelessRecipe(rj output, Object[] input) {
        SHAPELESS_RECIPES.add(new CraftingRecipe(output, input));
    }

    public static void addShapelessRecipe(rh output, Object[] input) {
        RecipeManager.addShapelessRecipe(new rj(output), input);
    }

    public static void addShapelessRecipe(aig output, Object[] input) {
        RecipeManager.addShapelessRecipe(new rj(output), input);
    }

    public static void addShapelessRecipe(rj output, Object[] input, String name, Configuration config, boolean defaultBoolean) {
        if (config != null && UEConfig.getConfigData(config, "Allow " + name + " Crafting", defaultBoolean)) {
            RecipeManager.addShapelessRecipe(output, input);
        }
    }

    public static void addShapelessRecipe(rj output, Object[] input, Configuration config, boolean defaultBoolean) {
        RecipeManager.addShapelessRecipe(output, input, output.a(), config, defaultBoolean);
    }

    public static List getShapelessRecipes() {
        return SHAPELESS_RECIPES;
    }

    public static CraftingRecipe getShapelessRecipeByOutput(rj output) {
        for (CraftingRecipe recipe : SHAPELESS_RECIPES) {
            if (recipe.output != output) continue;
            return recipe;
        }
        return null;
    }

    public static void addSmelting(rj input, rj output) {
        SMELTING_RECIPES.add(new SmeltingRecipe(input, output));
    }

    public static void addSmelting(rh input, rj output) {
        RecipeManager.addSmelting(new rj(input), output);
    }

    public static void addSmelting(aig input, rj output) {
        RecipeManager.addSmelting(new rj(input), output);
    }

    public static void addSmelting(rj input, rj output, String name, Configuration config, boolean defaultBoolean) {
        if (config != null && UEConfig.getConfigData(config, "Allow " + name + " Smelting", defaultBoolean)) {
            RecipeManager.addSmelting(input, output);
        }
    }

    public static void addSmelting(rj input, rj output, Configuration config, boolean defaultBoolean) {
        RecipeManager.addSmelting(input, output, output.a(), config, defaultBoolean);
    }

    public static List getSmeltingRecipes() {
        return SMELTING_RECIPES;
    }

    public static SmeltingRecipe getSmeltingRecipeByOutput(rj output) {
        for (SmeltingRecipe recipe : SMELTING_RECIPES) {
            if (recipe.output != output) continue;
            return recipe;
        }
        return null;
    }

    public static void registerRecipeHandler(String handlerName, IRecipeHandler handler) {
        if (!RECIPE_HANDLERS.containsKey(handlerName)) {
            RECIPE_HANDLERS.put(handlerName, handler);
        }
    }

    public static IRecipeHandler getRecipeHandler(String name) {
        return (IRecipeHandler)RECIPE_HANDLERS.get(name);
    }

    public static Map getAllCustomRecipes() {
        return RECIPE_HANDLERS;
    }

    public static void replaceRecipe(CraftingRecipe recipeToReplace, CraftingRecipe newRecipe) {
        for (CraftingRecipe recipe : SHAPED_RECIPES) {
            if (!recipe.isEqual(recipeToReplace)) continue;
            CraftingRecipe craftingRecipe = newRecipe;
        }
    }

    public static void replaceShapelessRecipe(CraftingRecipe recipeToReplace, CraftingRecipe newRecipe) {
        for (CraftingRecipe recipe : SHAPELESS_RECIPES) {
            if (!recipe.isEqual(recipeToReplace)) continue;
            CraftingRecipe craftingRecipe = newRecipe;
        }
    }

    public static void replaceSmeltingRecipe(SmeltingRecipe recipeToReplace, SmeltingRecipe newRecipe) {
        for (SmeltingRecipe recipe : SMELTING_RECIPES) {
            if (!recipe.isEqual(recipeToReplace)) continue;
            SmeltingRecipe smeltingRecipe = newRecipe;
        }
    }

    public static List findRecipe(rj output) {
        ArrayList<CraftingRecipe> returnList = new ArrayList<CraftingRecipe>();
        for (CraftingRecipe recipe : SHAPED_RECIPES) {
            if (!recipe.output.a(output)) continue;
            returnList.add(recipe);
        }
        return returnList;
    }

    public static List findShapelessRecipe(rj output) {
        ArrayList<CraftingRecipe> returnList = new ArrayList<CraftingRecipe>();
        for (CraftingRecipe recipe : SHAPELESS_RECIPES) {
            if (!recipe.output.a(output)) continue;
            returnList.add(recipe);
        }
        return returnList;
    }

    public static List findSmeltingRecipe(rj output) {
        ArrayList<SmeltingRecipe> returnList = new ArrayList<SmeltingRecipe>();
        for (SmeltingRecipe recipe : SMELTING_RECIPES) {
            if (!recipe.output.a(output)) continue;
            returnList.add(recipe);
        }
        return returnList;
    }

    public static void removeRecipe(rj output) {
        for (CraftingRecipe recipe : SHAPED_RECIPES) {
            if (!recipe.output.a(output)) continue;
            SHAPED_RECIPES.remove(recipe);
        }
    }

    public static void removeShapelessRecipe(rj output) {
        for (CraftingRecipe recipe : SHAPELESS_RECIPES) {
            if (!recipe.output.a(output)) continue;
            SHAPELESS_RECIPES.remove(recipe);
        }
    }

    public static void removeSmeltingRecipe(rj output) {
        for (SmeltingRecipe recipe : SMELTING_RECIPES) {
            if (!recipe.output.a(output)) continue;
            SMELTING_RECIPES.remove(recipe);
        }
    }

    public static void removeRecipe(CraftingRecipe output) {
        for (CraftingRecipe recipe : SHAPED_RECIPES) {
            if (!recipe.isEqual(output)) continue;
            SHAPED_RECIPES.remove(recipe);
            return;
        }
    }

    public static void removeShapelessRecipe(CraftingRecipe output) {
        for (CraftingRecipe recipe : SHAPELESS_RECIPES) {
            if (!recipe.isEqual(output)) continue;
            SHAPELESS_RECIPES.remove(recipe);
            return;
        }
    }

    public static void removeSmeltingRecipe(SmeltingRecipe output) {
        for (SmeltingRecipe recipe : SMELTING_RECIPES) {
            if (!recipe.isEqual(output)) continue;
            SMELTING_RECIPES.remove(recipe);
            return;
        }
    }

    public static void addRecipes() {
        for (Object recipe : SHAPED_RECIPES) {
            td.a().b().add(new ShapedOreRecipe(((CraftingRecipe)recipe).output, ((CraftingRecipe)recipe).input));
        }
        for (Object recipe : SHAPELESS_RECIPES) {
            td.a().b().add(new ShapelessOreRecipe(((CraftingRecipe)recipe).output, ((CraftingRecipe)recipe).input));
        }
        for (Object recipe : SMELTING_RECIPES) {
            tb.a().addSmelting(((SmeltingRecipe)recipe).input.c, ((SmeltingRecipe)recipe).input.j(), ((SmeltingRecipe)recipe).output);
        }
    }
}

