/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab;

import com.google.common.io.ByteArrayDataInput;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.Vector3;
import universalelectricity.electricity.ElectricityManager;
import universalelectricity.electricity.ElectricityNetwork;
import universalelectricity.implement.IConductor;
import universalelectricity.implement.IConnector;
import universalelectricity.prefab.TileEntityAdvanced;
import universalelectricity.prefab.network.IPacketReceiver;

public abstract class TileEntityConductor
extends TileEntityAdvanced
implements IConductor,
IPacketReceiver {
    private ElectricityNetwork network;
    public amm[] connectedBlocks = new amm[]{null, null, null, null, null, null};

    public TileEntityConductor() {
        this.reset();
    }

    @Override
    public ElectricityNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(ElectricityNetwork network) {
        this.network = network;
    }

    @Override
    public amm[] getConnectedBlocks() {
        return this.connectedBlocks;
    }

    @Override
    public void initiate() {
        this.refreshConnectedBlocks();
    }

    @Override
    public void updateConnection(amm tileEntity, ForgeDirection side) {
        if (tileEntity != null && tileEntity instanceof IConnector) {
            this.connectedBlocks[side.ordinal()] = tileEntity;
            if (tileEntity.getClass() == this.getClass()) {
                ElectricityManager.instance.mergeConnection(this.getNetwork(), ((TileEntityConductor)tileEntity).getNetwork());
            }
            return;
        }
        if (this.connectedBlocks[side.ordinal()] != null && this.connectedBlocks[side.ordinal()] instanceof IConductor) {
            ElectricityManager.instance.splitConnection(this, (IConductor)this.getConnectedBlocks()[side.ordinal()]);
        }
        this.connectedBlocks[side.ordinal()] = null;
    }

    @Override
    public void updateConnectionWithoutSplit(amm tileEntity, ForgeDirection side) {
        if (tileEntity != null && tileEntity instanceof IConnector) {
            this.connectedBlocks[side.ordinal()] = tileEntity;
            if (tileEntity.getClass() == this.getClass()) {
                ElectricityManager.instance.mergeConnection(this.getNetwork(), ((TileEntityConductor)tileEntity).getNetwork());
            }
            return;
        }
        this.connectedBlocks[side.ordinal()] = null;
    }

    @Override
    public void handlePacketData(bv network, int type, da packet, qg player, ByteArrayDataInput dataStream) {
        if (this.k.J) {
            this.refreshConnectedBlocks();
        }
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void reset() {
        this.network = null;
        if (ElectricityManager.instance != null) {
            ElectricityManager.instance.registerConductor(this);
        }
    }

    @Override
    public void refreshConnectedBlocks() {
        if (this.k != null) {
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                this.updateConnection(Vector3.getConnectorFromSide(this.k, Vector3.get(this), ForgeDirection.getOrientation((int)i)), ForgeDirection.getOrientation((int)i));
            }
        }
    }

    @Override
    public xe getWorld() {
        return this.k;
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return true;
    }
}

