/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity;

import cpw.mods.fml.common.Loader;
import java.io.File;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeVersion;
import universalelectricity.UEConfig;

public class UniversalElectricity {
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 9;
    public static final int REVISION_VERSION = 3;
    public static final String VERSION = "0.9.3";
    public static final Configuration CONFIGURATION = new Configuration(new File(Loader.instance().getConfigDir(), "UniversalElectricity/UniversalElectricity.cfg"));
    public static final float IC2_RATIO = UEConfig.getConfigData(CONFIGURATION, "IndustrialCraft Conversion Ratio", 7);
    public static final float BC3_RATIO = UEConfig.getConfigData(CONFIGURATION, "BuildCraft Conversion Ratio", 85);
    public static final float TO_IC2_RATIO = 1.0f / IC2_RATIO;
    public static final float TO_BC_RATIO = 1.0f / BC3_RATIO;
    public static final aco machine = new aco(acq.h);

    public static void versionLock(int major, int minor, int revision, boolean strict) {
        if (0 != major) {
            throw new RuntimeException("Universal Electricity wrong version! Require v" + major + "." + minor + "." + revision);
        }
        if (9 < minor) {
            throw new RuntimeException("Universal Electricity minor version is too old! Require v" + major + "." + minor + "." + revision);
        }
        if (3 < revision) {
            if (strict) {
                throw new RuntimeException("Universal Electricity is too old! Require v" + major + "." + minor + "." + revision);
            }
            System.out.println("Universal Electricity is not the specified version. Odd things might happen. Require " + major + "." + minor + "." + revision);
        }
    }

    public static void forgeLock(int major, int minor, int revision, boolean strict) {
        if (ForgeVersion.getMajorVersion() != major) {
            throw new RuntimeException("Universal Electricity: Wrong Minecraft Forge version! Require " + major + "." + minor + "." + revision);
        }
        if (ForgeVersion.getMinorVersion() < minor) {
            throw new RuntimeException("Universal Electricity: Minecraft Forge minor version is too old! Require " + major + "." + minor + "." + revision);
        }
        if (ForgeVersion.getRevisionVersion() < revision) {
            if (strict) {
                throw new RuntimeException("Universal Electricity: Minecraft Forge revision version is too old! Require " + major + "." + minor + "." + revision);
            }
            System.out.println("Universal Electricity Warning: Minecraft Forge is not the specified version. Odd things might happen. Require " + major + "." + minor + "." + revision);
        }
    }

    public static void forgeLock(int major, int minor, int revision) {
        UniversalElectricity.forgeLock(major, minor, revision, false);
    }
}

