/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.core.items.ICrowbar;
import railcraft.common.api.tracks.ITrackInstance;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.api.tracks.ITrackReversable;
import railcraft.common.api.tracks.ITrackTile;
import railcraft.common.api.tracks.TrackSpec;

public abstract class TrackInstanceBase
implements ITrackInstance {
    private alf block;
    public amm tileEntity;

    private alf getBlock() {
        if (this.block == null) {
            int id = this.getWorld().a(this.getX(), this.getY(), this.getZ());
            this.block = alf.p[id];
        }
        return this.block;
    }

    @Override
    public void setTile(amm tile) {
        this.tileEntity = tile;
    }

    @Override
    public int getBasicRailMetadata(ph cart) {
        return this.tileEntity.p();
    }

    @Override
    public void onMinecartPass(ph cart) {
    }

    @Override
    public boolean blockActivated(qg player) {
        tv current;
        if (this instanceof ITrackReversable && (current = player.bP()) != null && current.b() instanceof ICrowbar) {
            ITrackReversable track;
            track.setReversed(!(track = (ITrackReversable)((Object)this)).isReversed());
            this.markBlockNeedsUpdate();
            if (current.f()) {
                current.a(1, (ln)player);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onBlockPlaced(int side) {
        this.switchTrack(true);
        this.testPower();
        this.markBlockNeedsUpdate();
    }

    @Override
    public void onBlockPlacedBy(ln entityliving) {
        if (entityliving == null) {
            return;
        }
        if (this instanceof ITrackReversable) {
            int dir = jv.c((double)((double)(entityliving.z * 4.0f / 360.0f) + 0.5)) & 3;
            ((ITrackReversable)((Object)this)).setReversed(dir == 0 || dir == 1);
        }
        this.markBlockNeedsUpdate();
    }

    public void markBlockNeedsUpdate() {
        this.getWorld().h(this.tileEntity.l, this.tileEntity.m, this.tileEntity.n);
    }

    protected boolean isRailValid(xe world, int i, int j, int k2, int meta) {
        boolean valid = true;
        if (!world.isBlockSolidOnSide(i, j - 1, k2, ForgeDirection.UP)) {
            valid = false;
        }
        if (meta == 2 && !world.isBlockSolidOnSide(i + 1, j, k2, ForgeDirection.UP)) {
            valid = false;
        } else if (meta == 3 && !world.isBlockSolidOnSide(i - 1, j, k2, ForgeDirection.UP)) {
            valid = false;
        } else if (meta == 4 && !world.isBlockSolidOnSide(i, j, k2 - 1, ForgeDirection.UP)) {
            valid = false;
        } else if (meta == 5 && !world.isBlockSolidOnSide(i, j, k2 + 1, ForgeDirection.UP)) {
            valid = false;
        }
        return valid;
    }

    @Override
    public void onNeighborBlockChange(int id) {
        int meta = this.tileEntity.p();
        boolean valid = this.isRailValid(this.getWorld(), this.tileEntity.l, this.tileEntity.m, this.tileEntity.n, meta);
        if (!valid) {
            alf blockTrack = this.getBlock();
            blockTrack.c(this.getWorld(), this.tileEntity.l, this.tileEntity.m, this.tileEntity.n, 0, 0);
            this.getWorld().e(this.tileEntity.l, this.tileEntity.m, this.tileEntity.n, 0);
            return;
        }
        akg blockTrack = (akg)this.getBlock();
        if (id > 0 && alf.p[id].i() && this.isFlexibleRail() && akh.a((akh)new akh(blockTrack, this.getWorld(), this.tileEntity.l, this.tileEntity.m, this.tileEntity.n)) == 3) {
            this.switchTrack(false);
        }
        this.testPower();
    }

    protected void switchTrack(boolean flag) {
        int i = this.tileEntity.l;
        int j = this.tileEntity.m;
        int k2 = this.tileEntity.n;
        akg blockTrack = (akg)this.getBlock();
        new akh(blockTrack, this.getWorld(), i, j, k2).a(this.getWorld().z(i, j, k2), flag);
    }

    protected void testPower() {
        boolean powered;
        if (!(this instanceof ITrackPowered)) {
            return;
        }
        int i = this.tileEntity.l;
        int j = this.tileEntity.m;
        int k2 = this.tileEntity.n;
        ITrackPowered r2 = (ITrackPowered)((Object)this);
        int meta = this.tileEntity.p();
        boolean bl = powered = this.getWorld().z(i, j, k2) || this.getWorld().z(i, j + 1, k2) || this.testPowerPropagation(this.getWorld(), i, j, k2, this.getTrackSpec(), meta, r2.getPowerPropagation());
        if (powered != r2.isPowered()) {
            r2.setPowered(powered);
            alf blockTrack = this.getBlock();
            this.getWorld().h(i, j, k2, blockTrack.cm);
            this.getWorld().h(i, j - 1, k2, blockTrack.cm);
            if (meta == 2 || meta == 3 || meta == 4 || meta == 5) {
                this.getWorld().h(i, j + 1, k2, blockTrack.cm);
            }
            this.markBlockNeedsUpdate();
        }
    }

    protected boolean testPowerPropagation(xe world, int i, int j, int k2, TrackSpec spec, int meta, int maxDist) {
        return this.isConnectedRailPowered(world, i, j, k2, spec, meta, true, 0, maxDist) || this.isConnectedRailPowered(world, i, j, k2, spec, meta, false, 0, maxDist);
    }

    protected boolean isConnectedRailPowered(xe world, int i, int j, int k2, TrackSpec spec, int meta, boolean dir, int dist, int maxDist) {
        if (dist >= maxDist) {
            return false;
        }
        boolean powered = true;
        switch (meta) {
            case 0: {
                if (dir) {
                    ++k2;
                    break;
                }
                --k2;
                break;
            }
            case 1: {
                if (dir) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case 2: {
                if (dir) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    powered = false;
                }
                meta = 1;
                break;
            }
            case 3: {
                if (dir) {
                    --i;
                    ++j;
                    powered = false;
                } else {
                    ++i;
                }
                meta = 1;
                break;
            }
            case 4: {
                if (dir) {
                    ++k2;
                } else {
                    --k2;
                    ++j;
                    powered = false;
                }
                meta = 0;
                break;
            }
            case 5: {
                if (dir) {
                    ++k2;
                    ++j;
                    powered = false;
                } else {
                    --k2;
                }
                meta = 0;
            }
        }
        if (this.testPowered(world, i, j, k2, spec, dir, dist, maxDist, meta)) {
            return true;
        }
        return powered && this.testPowered(world, i, j - 1, k2, spec, dir, dist, maxDist, meta);
    }

    protected boolean testPowered(xe world, int i, int j, int k2, TrackSpec spec, boolean dir, int dist, int maxDist, int orientation) {
        int id = world.a(i, j, k2);
        alf blockTrack = this.getBlock();
        if (id == blockTrack.cm) {
            int meta = world.g(i, j, k2);
            amm tile = world.p(i, j, k2);
            if (tile instanceof ITrackTile) {
                ITrackInstance track = ((ITrackTile)tile).getTrackInstance();
                if (!(track instanceof ITrackPowered) || track.getTrackSpec() != spec) {
                    return false;
                }
                if (orientation == 1 && (meta == 0 || meta == 4 || meta == 5)) {
                    return false;
                }
                if (orientation == 0 && (meta == 1 || meta == 2 || meta == 3)) {
                    return false;
                }
                if (((ITrackPowered)track).isPowered()) {
                    if (world.z(i, j, k2) || world.z(i, j + 1, k2)) {
                        return true;
                    }
                    return this.isConnectedRailPowered(world, i, j, k2, spec, meta, dir, dist + 1, maxDist);
                }
            }
        }
        return false;
    }

    @Override
    public int getTextureIndex() {
        return this.getTrackSpec().getTextureIndex();
    }

    @Override
    public void writeToNBT(bh data) {
    }

    @Override
    public void readFromNBT(bh data) {
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    @Override
    public void updateEntity() {
    }

    @Override
    public float getExplosionResistance(double srcX, double srcY, double srcZ, lb exploder) {
        return 3.5f;
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
    }

    @Override
    public xe getWorld() {
        return this.tileEntity.k;
    }

    @Override
    public int getX() {
        return this.tileEntity.l;
    }

    @Override
    public int getY() {
        return this.tileEntity.m;
    }

    @Override
    public int getZ() {
        return this.tileEntity.n;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public boolean canMakeSlopes() {
        return true;
    }

    @Override
    public float getRailMaxSpeed(ph cart) {
        return 0.4f;
    }
}

