/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.signals;

public enum EnumSignalAspect {
    GREEN(0),
    BLINK_YELLOW(1),
    YELLOW(1),
    BLINK_RED(2),
    RED(2),
    OFF(3);

    private final byte id;
    private final int textureOffset;
    private static byte nextId;
    private static boolean blinkState;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumSignalAspect() {
        void textureOffset;
        this.textureOffset = textureOffset;
        this.id = EnumSignalAspect.getNextId();
    }

    public byte getId() {
        return this.id;
    }

    public int getTextureOffset() {
        return this.textureOffset;
    }

    public boolean isBlinkAspect() {
        return this == BLINK_YELLOW || this == BLINK_RED;
    }

    public static boolean isBlinkOn() {
        return blinkState;
    }

    public static void invertBlinkState() {
        blinkState = !blinkState;
    }

    public static EnumSignalAspect fromId(int id) {
        for (EnumSignalAspect a : EnumSignalAspect.values()) {
            if (a.getId() != id) continue;
            return a;
        }
        return RED;
    }

    public static EnumSignalAspect mostRestrictive(EnumSignalAspect first, EnumSignalAspect second) {
        if (first == null && second != null) {
            return second;
        }
        if (first != null && second == null) {
            return first;
        }
        if (first == null && second == null) {
            return RED;
        }
        if (first == OFF || second == OFF) {
            return RED;
        }
        if (first.getId() > second.getId()) {
            return first;
        }
        return second;
    }

    private static byte getNextId() {
        byte i = nextId;
        nextId = (byte)(nextId + 1);
        return i;
    }

    public String toString() {
        String[] sa = this.name().split("_");
        String out = "";
        for (String s2 : sa) {
            out = out + s2.substring(0, 1) + s2.substring(1).toLowerCase() + " ";
        }
        out = out.trim();
        return out;
    }

    static {
        nextId = 0;
    }
}

