/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.carts;

import railcraft.common.api.carts.CartBase;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.carts.IItemTransfer;
import railcraft.common.api.carts.ILinkageManager;
import railcraft.common.api.core.items.EnumItemType;

public abstract class TransferCartBase
extends CartBase
implements IItemTransfer {
    protected boolean passThrough = false;

    public TransferCartBase(xe world) {
        super(world);
    }

    @Override
    public tv offerItem(Object source, tv offer) {
        if (!this.passThrough && this.k_() > 0 && (offer = this.moveItemStack(offer, (kl)this)) == null) {
            return null;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.p);
        ph linkedCart = lm.getLinkedCartA(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            offer = ((IItemTransfer)linkedCart).offerItem(this, offer);
        }
        if (offer == null) {
            return null;
        }
        linkedCart = lm.getLinkedCartB(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            offer = ((IItemTransfer)linkedCart).offerItem(this, offer);
        }
        return offer;
    }

    @Override
    public tv requestItem(Object source) {
        tv result = null;
        if (!this.passThrough && this.k_() > 0 && (result = this.removeOneItem((kl)this)) != null) {
            return result;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.p);
        ph linkedCart = lm.getLinkedCartA(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem(this);
        }
        if (result != null) {
            return result;
        }
        linkedCart = lm.getLinkedCartB(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem(this);
        }
        return result;
    }

    @Override
    public tv requestItem(Object source, tv request) {
        tv result = null;
        if (!this.passThrough && this.k_() > 0 && (result = this.removeOneItem((kl)this, request)) != null) {
            return result;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.p);
        ph linkedCart = lm.getLinkedCartA(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem((Object)this, request);
        }
        if (result != null) {
            return result;
        }
        linkedCart = lm.getLinkedCartB(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem((Object)this, request);
        }
        return result;
    }

    @Override
    public tv requestItem(Object source, EnumItemType request) {
        tv result = null;
        if (!this.passThrough && this.k_() > 0 && (result = this.removeOneItem((kl)this, request)) != null) {
            return result;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.p);
        ph linkedCart = lm.getLinkedCartA(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem((Object)this, request);
        }
        if (result != null) {
            return result;
        }
        linkedCart = lm.getLinkedCartB(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem((Object)this, request);
        }
        return result;
    }

    protected final tv removeOneItem(kl inv) {
        for (int i = 0; i < inv.k_(); ++i) {
            tv slot = inv.a(i);
            if (slot == null) continue;
            return inv.a(i, 1);
        }
        return null;
    }

    protected final tv removeOneItem(kl inv, tv filter) {
        for (int i = 0; i < inv.k_(); ++i) {
            tv slot = inv.a(i);
            if (slot == null || filter == null || !slot.a(filter)) continue;
            return inv.a(i, 1);
        }
        return null;
    }

    protected final tv removeOneItem(kl inv, EnumItemType filter) {
        for (int i = 0; i < inv.k_(); ++i) {
            tv slot = inv.a(i);
            if (slot == null || !filter.isItemType(slot)) continue;
            return inv.a(i, 1);
        }
        return null;
    }

    protected final tv moveItemStack(tv stack, kl dest) {
        if (stack == null) {
            return null;
        }
        stack = stack.l();
        if (dest == null) {
            return stack;
        }
        boolean movedItem = false;
        do {
            int ii;
            movedItem = false;
            tv destStack = null;
            for (ii = 0; ii < dest.k_(); ++ii) {
                int maxStack;
                int room;
                destStack = dest.a(ii);
                if (destStack == null || !destStack.a(stack) || (room = (maxStack = Math.min(destStack.d(), dest.c())) - destStack.a) <= 0) continue;
                int move = Math.min(room, stack.a);
                destStack.a += move;
                stack.a -= move;
                if (stack.a <= 0) {
                    return null;
                }
                movedItem = true;
            }
            if (movedItem) continue;
            for (ii = 0; ii < dest.k_(); ++ii) {
                destStack = dest.a(ii);
                if (destStack != null) continue;
                if (stack.a <= dest.c()) {
                    dest.a(ii, stack);
                    return null;
                }
                dest.a(ii, stack.a(dest.c()));
                movedItem = true;
            }
        } while (movedItem);
        return stack;
    }
}

