/*
 * Decompiled with CFR 0.152.
 */
package net.uberkat.obsidian.common;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.PowerFramework;
import cpw.mods.fml.client.FMLClientHandler;
import dan200.computer.api.IComputerAccess;
import ic2.api.Direction;
import ic2.api.EnergyNet;
import net.minecraftforge.common.ForgeDirection;
import net.uberkat.obsidian.client.Sound;
import net.uberkat.obsidian.common.ObsidianIngots;
import obsidian.api.IElectricMachine;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.electricity.ElectricInfo;
import universalelectricity.prefab.TileEntityDisableable;

public abstract class TileEntityBasicMachine
extends TileEntityDisableable
implements IElectricMachine {
    public tv[] inventory;
    public Sound audio;
    public String soundURL;
    public int ENERGY_PER_TICK;
    public int operatingTicks = 0;
    public int energyStored = 0;
    public int TICKS_REQUIRED;
    public int currentTicksRequired;
    public int MAX_ENERGY;
    public int currentMaxEnergy;
    public int facing;
    public int packetTick = 0;
    public boolean isActive;
    public boolean prevActive;
    public boolean initialized;
    public String fullName;
    public String guiTexturePath;
    public IPowerProvider powerProvider;

    public TileEntityBasicMachine(String soundPath, String name, String path, int perTick, int ticksRequired, int maxEnergy) {
        this.ENERGY_PER_TICK = perTick;
        this.TICKS_REQUIRED = this.currentTicksRequired = ticksRequired;
        this.MAX_ENERGY = this.currentMaxEnergy = maxEnergy;
        this.soundURL = soundPath;
        this.fullName = name;
        this.guiTexturePath = path;
        this.isActive = false;
        if (PowerFramework.currentFramework != null) {
            this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
            this.powerProvider.configure(5, 25, 25, 25, maxEnergy / 10);
        }
    }

    @Override
    public void g() {
        if (!this.initialized && this.k != null) {
            if (ObsidianIngots.hooks.IC2Loaded) {
                EnergyNet.getForWorld(this.k).addTileEntity(this);
            }
            this.initialized = true;
        }
        if (this.audio == null && this.k.J) {
            this.audio = ObsidianIngots.audioHandler.getSound(this.fullName.replace(" ", ""), this.soundURL, this.k, this.l, this.m, this.n);
        }
        this.onUpdate();
        if (!this.k.J) {
            if (this.packetTick == 5) {
                this.sendPacket();
            }
            ++this.packetTick;
        }
        if (this.k.J) {
            this.audio.updateVolume((qg)FMLClientHandler.instance().getClient().g);
            if (!this.audio.isPlaying && this.isActive) {
                this.audio.play();
            } else if (this.audio.isPlaying && !this.isActive) {
                this.audio.stop();
            }
        }
        if (!this.k.J) {
            this.sendPacketWithRange();
        }
    }

    public boolean a(qg entityplayer) {
        return this.k.p(this.l, this.m, this.n) != this ? false : entityplayer.e((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5) <= 64.0;
    }

    public void l_() {
    }

    public void f() {
    }

    public String b() {
        return this.fullName;
    }

    public int c() {
        return 64;
    }

    public void w_() {
        super.w_();
        if (this.k.J) {
            this.audio.remove();
        }
    }

    @Override
    public boolean demandsEnergy() {
        return this.energyStored < this.currentMaxEnergy;
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        int rejects = 0;
        int neededEnergy = this.currentMaxEnergy - this.energyStored;
        if (i <= neededEnergy) {
            this.energyStored += i;
        } else if (i > neededEnergy) {
            this.energyStored += neededEnergy;
            rejects = i - neededEnergy;
        }
        return rejects;
    }

    @Override
    public boolean wrenchCanSetFacing(qg entityPlayer, int side) {
        return true;
    }

    @Override
    public short getFacing() {
        return (short)this.facing;
    }

    @Override
    public void setFacing(short direction) {
        if (this.initialized && ObsidianIngots.hooks.IC2Loaded) {
            EnergyNet.getForWorld(this.k).removeTileEntity(this);
        }
        this.initialized = false;
        this.facing = direction;
        this.sendPacket();
        if (ObsidianIngots.hooks.IC2Loaded) {
            EnergyNet.getForWorld(this.k).addTileEntity(this);
        }
        this.initialized = true;
    }

    @Override
    public boolean wrenchCanRemove(qg entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }

    @Override
    public void doWork() {
    }

    @Override
    public boolean acceptsEnergyFrom(amm emitter, Direction direction) {
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.initialized;
    }

    public int getScaledEnergyLevel(int i) {
        return this.energyStored * i / this.currentMaxEnergy;
    }

    public int getScaledProgress(int i) {
        return this.operatingTicks * i / this.currentTicksRequired;
    }

    @Override
    public double getMaxJoules() {
        return (float)this.currentMaxEnergy * UniversalElectricity.IC2_RATIO;
    }

    @Override
    public double getJoules(Object ... data) {
        return (float)this.energyStored * UniversalElectricity.IC2_RATIO;
    }

    @Override
    public void setJoules(double joules, Object ... data) {
        this.setEnergy((int)(joules * (double)UniversalElectricity.TO_IC2_RATIO));
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean canReceiveFromSide(ForgeDirection side) {
        return true;
    }

    @Override
    public double getVoltage() {
        return 120.0;
    }

    @Override
    public double wattRequest() {
        return ElectricInfo.getWatts((float)this.currentMaxEnergy * UniversalElectricity.IC2_RATIO) - ElectricInfo.getWatts((float)this.energyStored * UniversalElectricity.IC2_RATIO);
    }

    @Override
    public void onReceive(amm sender, double amps, double voltage, ForgeDirection side) {
        this.setEnergy(this.energyStored + (int)(ElectricInfo.getJoules(amps, voltage) * (double)UniversalElectricity.TO_IC2_RATIO));
    }

    public void setEnergy(int energy) {
        this.energyStored = Math.max(Math.min(energy, this.currentMaxEnergy), 0);
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.prevActive != active) {
            this.sendPacket();
        }
        this.prevActive = active;
    }

    @Override
    public String getType() {
        return this.b();
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer, String computerSide) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return 1;
        }
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    public int k_() {
        return this.inventory.length;
    }

    public tv a(int par1) {
        return this.inventory[par1];
    }

    public tv a(int par1, int par2) {
        if (this.inventory[par1] != null) {
            if (this.inventory[par1].a <= par2) {
                tv var3 = this.inventory[par1];
                this.inventory[par1] = null;
                return var3;
            }
            tv var3 = this.inventory[par1].a(par2);
            if (this.inventory[par1].a == 0) {
                this.inventory[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public tv a_(int par1) {
        if (this.inventory[par1] != null) {
            tv var2 = this.inventory[par1];
            this.inventory[par1] = null;
            return var2;
        }
        return null;
    }

    public void a(int par1, tv par2ItemStack) {
        this.inventory[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.a > this.c()) {
            par2ItemStack.a = this.c();
        }
    }

    @Override
    public int transferToAcceptor(int amount) {
        int rejects = 0;
        int neededEnergy = this.currentMaxEnergy - this.energyStored;
        if (amount <= neededEnergy) {
            this.energyStored += amount;
        } else if (amount > neededEnergy) {
            this.energyStored += neededEnergy;
            rejects = amount - neededEnergy;
        }
        return rejects;
    }

    @Override
    public boolean canReceive(ForgeDirection side) {
        return true;
    }
}

