/*
 * Decompiled with CFR 0.152.
 */
package net.uberkat.obsidian.common;

import buildcraft.api.power.PowerFramework;
import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import ic2.api.ElectricItem;
import ic2.api.IElectricItem;
import net.uberkat.obsidian.common.ObsidianIngots;
import net.uberkat.obsidian.common.PacketHandler;
import net.uberkat.obsidian.common.RecipeHandler;
import net.uberkat.obsidian.common.TileEntityBasicMachine;
import obsidian.api.IEnergizedItem;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.implement.IItemElectric;

public abstract class TileEntityAdvancedElectricMachine
extends TileEntityBasicMachine {
    public int SECONDARY_ENERGY_PER_TICK;
    public int MAX_SECONDARY_ENERGY;
    public int secondaryEnergyStored = 0;

    public TileEntityAdvancedElectricMachine(String soundPath, String name, String path, int perTick, int secondaryPerTick, int ticksRequired, int maxEnergy, int maxSecondaryEnergy) {
        super(soundPath, name, path, perTick, ticksRequired, maxEnergy);
        this.inventory = new tv[5];
        this.SECONDARY_ENERGY_PER_TICK = secondaryPerTick;
        this.MAX_SECONDARY_ENERGY = maxSecondaryEnergy;
    }

    public abstract int getFuelTicks(tv var1);

    @Override
    public void onUpdate() {
        int fuelTicks;
        int energyNeeded;
        boolean testActive;
        boolean bl = testActive = this.operatingTicks > 0;
        if (this.inventory[3] != null) {
            if (this.energyStored < this.currentMaxEnergy) {
                IElectricItem item;
                if (this.inventory[3].b() instanceof IEnergizedItem) {
                    int received = 0;
                    energyNeeded = this.currentMaxEnergy - this.energyStored;
                    IEnergizedItem item2 = (IEnergizedItem)this.inventory[3].b();
                    if (item2.getRate() <= energyNeeded) {
                        received = item2.discharge(this.inventory[3], item2.getRate());
                    } else if (item2.getRate() > energyNeeded) {
                        item2.setEnergy(this.inventory[3], item2.getEnergy(this.inventory[3]) - energyNeeded);
                        received = energyNeeded;
                    }
                    this.setEnergy(this.energyStored + received);
                } else if (this.inventory[3].b() instanceof IItemElectric) {
                    IItemElectric electricItem = (IItemElectric)this.inventory[3].b();
                    if (electricItem.canProduceElectricity()) {
                        double joulesReceived = electricItem.onUse(electricItem.getMaxJoules() * 0.005, this.inventory[3]);
                        this.setEnergy(this.energyStored + (int)(joulesReceived * (double)UniversalElectricity.TO_IC2_RATIO));
                    }
                } else if (this.inventory[3].b() instanceof IElectricItem && (item = (IElectricItem)this.inventory[3].b()).canProvideEnergy()) {
                    int gain = ElectricItem.discharge(this.inventory[3], this.currentMaxEnergy - this.energyStored, 3, false, false);
                    this.setEnergy(this.energyStored + gain);
                }
            }
            if (this.inventory[3].c == tt.aC.cf && this.energyStored <= this.MAX_ENERGY - 1000) {
                this.setEnergy(this.energyStored + 1000);
                --this.inventory[3].a;
                if (this.inventory[3].a <= 0) {
                    this.inventory[3] = null;
                }
            }
        }
        if (this.inventory[1] != null && this.secondaryEnergyStored == 0 && (fuelTicks = this.getFuelTicks(this.inventory[1])) > 0) {
            energyNeeded = this.MAX_SECONDARY_ENERGY - this.secondaryEnergyStored;
            if (fuelTicks <= energyNeeded) {
                this.setSecondaryEnergy(this.secondaryEnergyStored + fuelTicks);
            } else if (fuelTicks > energyNeeded) {
                this.setSecondaryEnergy(this.secondaryEnergyStored + energyNeeded);
            }
            --this.inventory[1].a;
            if (this.inventory[1].a == 0) {
                this.inventory[1] = null;
            }
        }
        if (this.inventory[4] != null) {
            int energyToAdd = 0;
            int ticksToRemove = 0;
            if (this.inventory[4].a(new tv(ObsidianIngots.SpeedUpgrade))) {
                if (this.currentTicksRequired == this.TICKS_REQUIRED) {
                    ticksToRemove = 150;
                }
            } else if (this.inventory[4].a(new tv(ObsidianIngots.EnergyUpgrade))) {
                if (this.currentMaxEnergy == this.MAX_ENERGY) {
                    energyToAdd = 600;
                }
            } else if (this.inventory[4].a(new tv(ObsidianIngots.UltimateUpgrade))) {
                if (this.currentTicksRequired == this.TICKS_REQUIRED) {
                    ticksToRemove = 150;
                }
                if (this.currentMaxEnergy == this.MAX_ENERGY) {
                    energyToAdd = 600;
                }
            }
            this.currentMaxEnergy += energyToAdd;
            this.currentTicksRequired -= ticksToRemove;
        } else if (this.inventory[4] == null) {
            this.currentTicksRequired = this.TICKS_REQUIRED;
            this.currentMaxEnergy = this.MAX_ENERGY;
        }
        if (this.canOperate() && this.operatingTicks + 1 < this.currentTicksRequired && this.secondaryEnergyStored >= this.SECONDARY_ENERGY_PER_TICK) {
            ++this.operatingTicks;
            this.secondaryEnergyStored -= this.SECONDARY_ENERGY_PER_TICK;
            this.energyStored -= this.ENERGY_PER_TICK;
        } else if (this.operatingTicks + 1 >= this.currentTicksRequired) {
            if (!this.k.J) {
                this.operate();
            }
            this.operatingTicks = 0;
            this.secondaryEnergyStored -= this.SECONDARY_ENERGY_PER_TICK;
            this.energyStored -= this.ENERGY_PER_TICK;
        }
        if (this.energyStored < 0) {
            this.energyStored = 0;
        }
        if (this.secondaryEnergyStored < 0) {
            this.secondaryEnergyStored = 0;
        }
        if (this.energyStored > this.currentMaxEnergy) {
            this.energyStored = this.currentMaxEnergy;
        }
        if (this.secondaryEnergyStored > this.MAX_SECONDARY_ENERGY) {
            this.secondaryEnergyStored = this.MAX_SECONDARY_ENERGY;
        }
        if (!this.canOperate()) {
            this.operatingTicks = 0;
        }
        if (!this.k.J && testActive != this.operatingTicks > 0) {
            if (this.operatingTicks > 0) {
                this.setActive(true);
            } else if (!this.canOperate()) {
                this.setActive(false);
            }
        }
    }

    @Override
    public void operate() {
        tv itemstack;
        if (!this.canOperate()) {
            return;
        }
        if (this.inventory[0].b().s()) {
            itemstack = RecipeHandler.getOutput(this.inventory[0], false, this.getRecipes()).l();
            this.inventory[0] = new tv(this.inventory[0].b().r());
        } else {
            itemstack = RecipeHandler.getOutput(this.inventory[0], true, this.getRecipes()).l();
        }
        if (this.inventory[0].a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[2] == null) {
            this.inventory[2] = itemstack;
        } else {
            this.inventory[2].a += itemstack.a;
        }
    }

    @Override
    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        if (this.energyStored < this.ENERGY_PER_TICK) {
            return false;
        }
        if (this.secondaryEnergyStored < this.SECONDARY_ENERGY_PER_TICK) {
            return false;
        }
        tv itemstack = RecipeHandler.getOutput(this.inventory[0], false, this.getRecipes());
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].a(itemstack)) {
            return false;
        }
        return this.inventory[2].a + itemstack.a <= this.inventory[2].d();
    }

    @Override
    public void sendPacket() {
        PacketHandler.sendAdvancedElectricMachinePacket(this);
    }

    @Override
    public void sendPacketWithRange() {
        PacketHandler.sendAdvancedElectricMachinePacketWithRange(this, 50.0);
    }

    @Override
    public void handlePacketData(bv network, da packet, qg player, ByteArrayDataInput dataStream) {
        try {
            this.facing = dataStream.readInt();
            this.isActive = dataStream.readByte() != 0;
            this.operatingTicks = dataStream.readInt();
            this.energyStored = dataStream.readInt();
            this.secondaryEnergyStored = dataStream.readInt();
            this.currentMaxEnergy = dataStream.readInt();
            this.currentTicksRequired = dataStream.readInt();
            this.k.i(this.l, this.m, this.n);
        }
        catch (Exception e) {
            System.out.println("[ObsidianIngots] Error while handling tile entity packet.");
            e.printStackTrace();
        }
    }

    public void a(bh nbtTags) {
        super.a(nbtTags);
        if (PowerFramework.currentFramework != null) {
            PowerFramework.currentFramework.loadPowerProvider(this, nbtTags);
        }
        bp tagList = nbtTags.m("Items");
        this.inventory = new tv[this.k_()];
        for (int slots = 0; slots < tagList.c(); ++slots) {
            bh tagCompound = (bh)tagList.b(slots);
            byte slotID = tagCompound.c("Slot");
            if (slotID < 0 || slotID >= this.inventory.length) continue;
            this.inventory[slotID] = tv.a((bh)tagCompound);
        }
        this.operatingTicks = nbtTags.e("operatingTicks");
        this.energyStored = nbtTags.e("energyStored");
        this.secondaryEnergyStored = nbtTags.e("secondaryEnergyStored");
        this.prevActive = this.isActive = nbtTags.n("isActive");
        this.facing = nbtTags.e("facing");
    }

    public void b(bh nbtTags) {
        super.b(nbtTags);
        if (PowerFramework.currentFramework != null) {
            PowerFramework.currentFramework.savePowerProvider(this, nbtTags);
        }
        nbtTags.a("operatingTicks", this.operatingTicks);
        nbtTags.a("energyStored", this.energyStored);
        nbtTags.a("secondaryEnergyStored", this.secondaryEnergyStored);
        nbtTags.a("isActive", this.isActive);
        nbtTags.a("facing", this.facing);
        bp tagList = new bp();
        for (int slots = 0; slots < this.inventory.length; ++slots) {
            if (this.inventory[slots] == null) continue;
            bh tagCompound = new bh();
            tagCompound.a("Slot", (byte)slots);
            this.inventory[slots].b(tagCompound);
            tagList.a((bu)tagCompound);
        }
        nbtTags.a("Items", (bu)tagList);
    }

    public void setSecondaryEnergy(int energy) {
        this.secondaryEnergyStored = Math.max(Math.min(energy, this.getFuelTicks(this.inventory[1])), 0);
    }

    public int getScaledSecondaryEnergyLevel(int i) {
        return this.secondaryEnergyStored * i / this.MAX_SECONDARY_ENERGY;
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getSecondaryStored", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.energyStored};
            }
            case 1: {
                return new Object[]{this.secondaryEnergyStored};
            }
            case 2: {
                return new Object[]{this.operatingTicks};
            }
            case 3: {
                return new Object[]{this.isActive};
            }
            case 4: {
                return new Object[]{this.facing};
            }
            case 5: {
                return new Object[]{this.canOperate()};
            }
            case 6: {
                return new Object[]{this.currentMaxEnergy};
            }
            case 7: {
                return new Object[]{this.currentMaxEnergy - this.energyStored};
            }
        }
        System.err.println("[ObsidianIngots] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }
}

