/*
 * Decompiled with CFR 0.152.
 */
package net.uberkat.obsidian.client;

import java.net.URL;
import paulscode.sound.SoundSystem;

public class Sound {
    public SoundSystem soundSystem;
    public String soundPath;
    public String identifier;
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public xe worldObj;
    public boolean isPlaying = false;

    public Sound(SoundSystem system, String id, String sound, xe world, int x, int y, int z) {
        this.soundSystem = system;
        this.soundPath = sound;
        this.identifier = id;
        this.worldObj = world;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        URL url = this.getClass().getClassLoader().getResource("sounds/" + sound);
        if (url == null) {
            System.out.println("[ObsidianIngots] Invalid sound file: " + sound);
        }
        this.soundSystem.newSource(false, id, url, sound, true, (float)x, (float)y, (float)z, 0, 16.0f);
        this.soundSystem.activate(id);
    }

    public void play() {
        if (this.isPlaying) {
            return;
        }
        this.soundSystem.play(this.identifier);
        this.isPlaying = true;
    }

    public void stop() {
        if (!this.isPlaying) {
            return;
        }
        this.soundSystem.stop(this.identifier);
        this.isPlaying = false;
    }

    public void remove() {
        if (this.isPlaying) {
            this.stop();
        }
        this.soundSystem.removeSource(this.identifier);
    }

    public void updateVolume(qg entityplayer) {
        float volume = 0.0f;
        if (!this.isPlaying) {
            volume = 0.0f;
            return;
        }
        double playerDistance = entityplayer.t + entityplayer.u + entityplayer.v;
        double machineDistance = this.xCoord + this.yCoord + this.zCoord;
        double distanceVolume = Math.abs((playerDistance - machineDistance) * 0.1);
        volume = (float)Math.max(1.0 - distanceVolume, 0.0);
        this.soundSystem.setVolume(this.identifier, volume);
    }
}

