/*
 * Decompiled with CFR 0.152.
 */
package ic2.api;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;

public final class Ic2Recipes {
    private static List TileEntityCompressor_recipes;
    private static List TileEntityExtractor_recipes;
    private static List TileEntityMacerator_recipes;
    private static List TileEntityRecycler_blacklist;
    private static List TileEntityMatter_amplifiers;

    public static void addCraftingRecipe(tv result, Object ... args) {
        try {
            Class.forName(Ic2Recipes.getPackage() + ".common.AdvRecipe").getMethod("addAndRegister", tv.class, Array.newInstance(Object.class, 0).getClass()).invoke(null, result, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addShapelessCraftingRecipe(tv result, Object ... args) {
        try {
            Class.forName(Ic2Recipes.getPackage() + ".common.AdvShapelessRecipe").getMethod("addAndRegister", tv.class, Array.newInstance(Object.class, 0).getClass()).invoke(null, result, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List getCompressorRecipes() {
        if (TileEntityCompressor_recipes == null) {
            try {
                TileEntityCompressor_recipes = (List)Class.forName(Ic2Recipes.getPackage() + ".common.TileEntityCompressor").getField("recipes").get(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return TileEntityCompressor_recipes;
    }

    public static void addCompressorRecipe(tv input, tv output) {
        Ic2Recipes.getCompressorRecipes().add(new AbstractMap.SimpleEntry<tv, tv>(input, output));
    }

    public static tv getCompressorOutputFor(tv input, boolean adjustInput) {
        return Ic2Recipes.getOutputFor(input, adjustInput, Ic2Recipes.getCompressorRecipes());
    }

    public static List getExtractorRecipes() {
        if (TileEntityExtractor_recipes == null) {
            try {
                TileEntityExtractor_recipes = (List)Class.forName(Ic2Recipes.getPackage() + ".common.TileEntityExtractor").getField("recipes").get(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return TileEntityExtractor_recipes;
    }

    public static void addExtractorRecipe(tv input, tv output) {
        Ic2Recipes.getExtractorRecipes().add(new AbstractMap.SimpleEntry<tv, tv>(input, output));
    }

    public static tv getExtractorOutputFor(tv input, boolean adjustInput) {
        return Ic2Recipes.getOutputFor(input, adjustInput, Ic2Recipes.getExtractorRecipes());
    }

    public static List getMaceratorRecipes() {
        if (TileEntityMacerator_recipes == null) {
            try {
                TileEntityMacerator_recipes = (List)Class.forName(Ic2Recipes.getPackage() + ".common.TileEntityMacerator").getField("recipes").get(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return TileEntityMacerator_recipes;
    }

    public static void addMaceratorRecipe(tv input, tv output) {
        Ic2Recipes.getMaceratorRecipes().add(new AbstractMap.SimpleEntry<tv, tv>(input, output));
    }

    public static tv getMaceratorOutputFor(tv input, boolean adjustInput) {
        return Ic2Recipes.getOutputFor(input, adjustInput, Ic2Recipes.getMaceratorRecipes());
    }

    private static tv getOutputFor(tv input, boolean adjustInput, List recipeList) {
        assert (input != null);
        for (Map.Entry entry : recipeList) {
            if (!((tv)entry.getKey()).a(input) || input.a < ((tv)entry.getKey()).a) continue;
            if (adjustInput) {
                input.a -= ((tv)entry.getKey()).a;
            }
            return ((tv)entry.getValue()).l();
        }
        return null;
    }

    public static List getRecyclerBlacklist() {
        if (TileEntityRecycler_blacklist == null) {
            try {
                TileEntityRecycler_blacklist = (List)Class.forName(Ic2Recipes.getPackage() + ".common.TileEntityRecycler").getField("blacklist").get(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return TileEntityRecycler_blacklist;
    }

    public static void addRecyclerBlacklistItem(tv newBlacklistedItem) {
        Ic2Recipes.getRecyclerBlacklist().add(newBlacklistedItem);
    }

    public static void addRecyclerBlacklistItem(tt newBlacklistedItem) {
        Ic2Recipes.addRecyclerBlacklistItem(new tv(newBlacklistedItem, 1, -1));
    }

    public static void addRecyclerBlacklistItem(alf newBlacklistedBlock) {
        Ic2Recipes.addRecyclerBlacklistItem(new tv(newBlacklistedBlock, 1, -1));
    }

    public static boolean isRecyclerInputBlacklisted(tv itemStack) {
        for (tv blackItem : Ic2Recipes.getRecyclerBlacklist()) {
            if (!itemStack.a(blackItem)) continue;
            return true;
        }
        return false;
    }

    public static List getScrapboxDrops() {
        try {
            return (List)Class.forName(Ic2Recipes.getPackage() + ".common.ItemScrapbox").getMethod("getDropList", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addScrapboxDrop(tv dropItem, float chance) {
        try {
            Class.forName(Ic2Recipes.getPackage() + ".common.ItemScrapbox").getMethod("addDrop", tv.class, Float.TYPE).invoke(null, dropItem, Float.valueOf(chance));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addScrapboxDrop(tt dropItem, float chance) {
        Ic2Recipes.addScrapboxDrop(new tv(dropItem, 1), chance);
    }

    public static void addScrapboxDrop(alf dropItem, float chance) {
        Ic2Recipes.addScrapboxDrop(new tv(dropItem), chance);
    }

    public static List getMatterAmplifiers() {
        if (TileEntityMatter_amplifiers == null) {
            try {
                TileEntityMatter_amplifiers = (List)Class.forName(Ic2Recipes.getPackage() + ".common.TileEntityMatter").getField("amplifiers").get(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return TileEntityMatter_amplifiers;
    }

    public static void addMatterAmplifier(tv amplifierItem, int value) {
        Ic2Recipes.getMatterAmplifiers().add(new AbstractMap.SimpleEntry<tv, Integer>(amplifierItem, value));
    }

    public static void addMatterAmplifier(tt amplifierItem, int value) {
        Ic2Recipes.addMatterAmplifier(new tv(amplifierItem, 1, -1), value);
    }

    public static void addMatterAmplifier(alf amplifierItem, int value) {
        Ic2Recipes.addMatterAmplifier(new tv(amplifierItem, 1, -1), value);
    }

    private static String getPackage() {
        Package pkg = Ic2Recipes.class.getPackage();
        if (pkg != null) {
            return pkg.getName().substring(0, pkg.getName().lastIndexOf(46));
        }
        return "ic2";
    }
}

