/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.liquids;

import buildcraft.api.liquids.ILiquidTank;
import buildcraft.api.liquids.LiquidStack;

public class LiquidTank
implements ILiquidTank {
    private LiquidStack liquid;
    private int capacity;

    public LiquidTank(int capacity) {
        this(null, capacity);
    }

    public LiquidTank(int liquidId, int quantity, int capacity) {
        this(new LiquidStack(liquidId, quantity), capacity);
    }

    public LiquidTank(LiquidStack liquid, int capacity) {
        this.liquid = liquid;
        this.capacity = capacity;
    }

    @Override
    public LiquidStack getLiquid() {
        return this.liquid;
    }

    @Override
    public void setLiquid(LiquidStack liquid) {
        this.liquid = liquid;
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int fill(LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID <= 0) {
            return 0;
        }
        if (this.liquid == null || this.liquid.itemID <= 0) {
            if (resource.amount <= this.capacity) {
                if (doFill) {
                    this.liquid = resource.copy();
                }
                return resource.amount;
            }
            if (doFill) {
                this.liquid = resource.copy();
                this.liquid.amount = this.capacity;
            }
            return this.capacity;
        }
        if (!this.liquid.isLiquidEqual(resource)) {
            return 0;
        }
        int space = this.capacity - this.liquid.amount;
        if (resource.amount <= space) {
            if (doFill) {
                this.liquid.amount += resource.amount;
            }
            return resource.amount;
        }
        if (doFill) {
            this.liquid.amount = this.capacity;
        }
        return space;
    }

    @Override
    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid == null || this.liquid.itemID <= 0) {
            return null;
        }
        if (this.liquid.amount <= 0) {
            return null;
        }
        int used = maxDrain;
        if (this.liquid.amount < used) {
            used = this.liquid.amount;
        }
        if (doDrain) {
            this.liquid.amount -= used;
        }
        LiquidStack drained = new LiquidStack(this.liquid.itemID, used, this.liquid.itemMeta);
        if (this.liquid.amount <= 0) {
            this.liquid = null;
        }
        return drained;
    }
}

