/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.DNA;

import com.advGenetics.AdvGenetics;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;

public enum Transmutator {
    BASIC(0, Entity.class, "basic", "Basic Gen", 0, 0, true),
    NO_FALL(1, EntityChicken.class, "nofall", "No-Fall", 20, 16, AdvGenetics.allow_NO_FALL),
    MILK_PRODUCER(3, EntityCow.class, "milkproducer", "Infinite Milk", 4, 6, AdvGenetics.allow_MILK_PRODUCER),
    SPEED(4, EntityOcelot.class, "speed", "Speed", 23, 12, AdvGenetics.allow_SPEED),
    SHEARABLE(5, EntitySheep.class, "shearable", "Wooly", 4, 8, AdvGenetics.allow_SHEARABLE),
    GRASS_AS_FOOD(6, EntitySheep.class, "grassasfood", "Eat Grass", 8, 8, AdvGenetics.allow_GRASS_AS_FOOD),
    HIGH_JUMP(7, EntityHorse.class, "highjump", "Jump", 22, 16, AdvGenetics.allow_HIGH_JUMP),
    WATER_BREATH(8, EntitySquid.class, "waterbreath", "Water breather", 18, 16, AdvGenetics.allow_WATER_BREATH),
    FLY(9, EntityBat.class, "fly", "Fly", 34, 28, AdvGenetics.allow_FLY),
    STEW(10, EntityMooshroom.class, "stew", "Produce stew", 7, 8, AdvGenetics.allow_STEW),
    TELEPORT(11, EntityEnderman.class, "teleport", "Teleporter", 24, 22, AdvGenetics.allow_TELEPORT),
    DEATH_ENDERCHEST(12, EntityEnderman.class, "deathenderchest", "Save your inventory", 38, 14, AdvGenetics.allow_DEATH_ENDERCHEST),
    LAVA_SWIM(13, EntityPigZombie.class, "lavaswim", "Swim in lava", 40, 22, AdvGenetics.allow_LAVA_SWIM),
    FIREBALLS(14, EntityBlaze.class, "fireballs", "Shoot fireballs", 24, 20, AdvGenetics.allow_FIREBALLS),
    SELF_EXPLODE(15, EntityCreeper.class, "selfexplode", "Explode yourself", 34, 16, AdvGenetics.allow_SELF_EXPLODE),
    FIREBALLS_EXPLODE(16, EntityGhast.class, "fireballsexplode", "Destroy blocks with fireballs", 42, 28, AdvGenetics.allow_FIREBALLS_EXPLODE),
    MORE_HEARTS(19, EntityIronGolem.class, "morehearts", "More life", 28, 14, AdvGenetics.allow_MORE_HEARTS),
    WITHERS_HIT(21, EntityWither.class, "witherhit", "Withers hit", 18, 10, AdvGenetics.allow_WITHERS_HIT),
    ENDER_HEALTH(22, EntityDragon.class, "enderhealth", "Ender health", 22, 12, AdvGenetics.allow_ENDER_HEALTH),
    POTION_THROWER(23, EntityWitch.class, "potionthrower", "Throw potion", 18, 16, AdvGenetics.allow_POTION_THROWER);

    public Class holder;
    public String hash;
    public String description;
    public int rarity;
    public int id;
    public int mobSpecID;
    public int breedingState;
    public boolean allowed;
    public static Transmutator[] valid_transmutators;

    private Transmutator(int id, Class<? extends Entity> holder, String hash, String description, int rarity, int breedingState, boolean allowed) {
        this.holder = holder;
        this.hash = Transmutator.toMD5(hash);
        this.description = description;
        this.rarity = rarity;
        this.id = id;
        this.mobSpecID = 0;
        this.breedingState = breedingState;
        this.allowed = allowed;
    }

    public static ArrayList<Transmutator> getRandomTransmutatorsByEntityClass(Entity entity, Random random) {
        ArrayList<Transmutator> output = new ArrayList<Transmutator>();
        if (entity != null) {
            for (Transmutator trans : valid_transmutators) {
                if (!trans.holder.equals(entity.getClass()) || random.nextInt(8 + trans.rarity) > 12 || !trans.allowed) continue;
                output.add(trans);
            }
            if (random.nextInt(50) <= 25) {
                output.add(BASIC);
            }
            if (output.size() == 0) {
                output.add(BASIC);
            }
        }
        return output;
    }

    public static String getHashString(ArrayList<Transmutator> list) {
        String output = "";
        for (Transmutator trans : list) {
            output = output + trans.hash + ";";
        }
        return output;
    }

    public static Transmutator getByHash(String hash) {
        for (Transmutator trans : valid_transmutators) {
            if (!trans.hash.equals(hash)) continue;
            return trans;
        }
        return null;
    }

    public static String toMD5(String input) {
        try {
            String output = "";
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(input.getBytes());
            byte[] digest = md.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            output = bigInt.toString(16);
            while (output.length() < 32) {
                output = "0" + output;
            }
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int getIDByName(String name) {
        for (Transmutator trans : valid_transmutators) {
            if (!trans.description.equals(name)) continue;
            return trans.id;
        }
        return -1;
    }

    public static String getHashByID(int id) {
        for (Transmutator trans : valid_transmutators) {
            if (trans.id != id) continue;
            return trans.hash;
        }
        return "";
    }

    public static String getDescriptionByHash(String hash) {
        for (Transmutator trans : valid_transmutators) {
            if (!trans.hash.equals(hash)) continue;
            return trans.description;
        }
        return null;
    }

    public static int getBreedingStateByHash(String hash) {
        for (Transmutator trans : valid_transmutators) {
            if (!trans.hash.equals(hash)) continue;
            return trans.breedingState;
        }
        return -1;
    }

    static {
        valid_transmutators = new Transmutator[]{BASIC, NO_FALL, MILK_PRODUCER, SPEED, SHEARABLE, GRASS_AS_FOOD, HIGH_JUMP, WATER_BREATH, FLY, STEW, TELEPORT, DEATH_ENDERCHEST, LAVA_SWIM, FIREBALLS, SELF_EXPLODE, FIREBALLS_EXPLODE, MORE_HEARTS, WITHERS_HIT, ENDER_HEALTH, POTION_THROWER};
    }
}

