/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFTreeGenerator;
import twilightforest.world.TFWorld;

public class TFGenCanopyTree
extends TFTreeGenerator {
    protected int minHeight = 20;
    protected int chanceAddFirstFive = 3;
    protected int chanceAddSecondFive = 8;

    public TFGenCanopyTree() {
        this(false);
    }

    public TFGenCanopyTree(boolean par1) {
        super(par1);
        this.treeBlock = TFBlocks.log.cF;
        this.treeMeta = 1;
        this.branchMeta = 13;
        this.leafBlock = TFBlocks.leaves.cF;
        this.leafMeta = 1;
        this.rootBlock = TFBlocks.root.cF;
        this.rootMeta = 0;
    }

    @Override
    public boolean a(abv world, Random random, int x, int y, int z2) {
        ajz materialUnder = world.g(x, y - 1, z2);
        if (materialUnder != ajz.b && materialUnder != ajz.c || y >= TFWorld.MAXHEIGHT - 12) {
            return false;
        }
        int treeHeight = this.minHeight;
        if (random.nextInt(this.chanceAddFirstFive) == 0) {
            treeHeight += random.nextInt(5);
            if (random.nextInt(this.chanceAddSecondFive) == 0) {
                treeHeight += random.nextInt(5);
            }
        }
        this.buildBranch(world, x, y, z2, 0, treeHeight, 0.0, 0.0, true, random);
        int numBranches = 3 + random.nextInt(2);
        double offset = random.nextDouble();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch(world, x, y, z2, treeHeight - 10 + b, 9.0, 0.3 * (double)b + offset, 0.2, false, random);
        }
        if (this.hasAirAround((ace)world, x, y - 1, z2)) {
            this.a(world, x, y - 1, z2, this.treeBlock, this.treeMeta);
        } else {
            this.a(world, x, y - 1, z2, this.rootBlock, this.rootMeta);
        }
        int numRoots = 3 + random.nextInt(2);
        offset = random.nextDouble();
        for (int b = 0; b < numRoots; ++b) {
            this.buildRoot(world, x, y, z2, offset, b);
        }
        return true;
    }

    void buildBranch(abv world, int x, int y, int z2, int height, double length, double angle, double tilt, boolean trunk, Random treeRNG) {
        int[] src = new int[]{x, y + height, z2};
        int[] dest = TFGenCanopyTree.translate(src[0], src[1], src[2], length, angle, tilt);
        this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1], dest[2], this.treeBlock, trunk ? this.treeMeta : this.branchMeta, true);
        if (trunk) {
            this.addFirefly(world, x, y, z2, 3 + treeRNG.nextInt(7), treeRNG.nextDouble());
        }
        this.putBlockAndMetadata(world, dest[0] + 1, dest[1], dest[2], this.treeBlock, this.branchMeta, true);
        this.putBlockAndMetadata(world, dest[0] - 1, dest[1], dest[2], this.treeBlock, this.branchMeta, true);
        this.putBlockAndMetadata(world, dest[0], dest[1], dest[2] + 1, this.treeBlock, this.branchMeta, true);
        this.putBlockAndMetadata(world, dest[0], dest[1], dest[2] - 1, this.treeBlock, this.branchMeta, true);
        this.drawCircle(world, dest[0], dest[1] - 1, dest[2], 3, this.leafBlock, this.leafMeta, false);
        this.drawCircle(world, dest[0], dest[1], dest[2], 4, this.leafBlock, this.leafMeta, false);
        this.drawCircle(world, dest[0], dest[1] + 1, dest[2], 2, this.leafBlock, this.leafMeta, false);
    }

    private void addFirefly(abv world, int x, int y, int z2, int height, double angle) {
        int iAngle = (int)(angle * 4.0);
        if (iAngle == 0) {
            this.putBlockAndMetadata(world, x + 1, y + height, z2, TFBlocks.firefly.cF, 0, false);
        } else if (iAngle == 1) {
            this.putBlockAndMetadata(world, x - 1, y + height, z2, TFBlocks.firefly.cF, 0, false);
        } else if (iAngle == 2) {
            this.putBlockAndMetadata(world, x, y + height, z2 + 1, TFBlocks.firefly.cF, 0, false);
        } else if (iAngle == 3) {
            this.putBlockAndMetadata(world, x, y + height, z2 - 1, TFBlocks.firefly.cF, 0, false);
        }
    }
}

