/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;

public class CustomColorizer {
    private static int[] grassColors = null;
    private static int[] waterColors = null;
    private static int[] foliageColors = null;
    private static int[] foliagePineColors = null;
    private static int[] foliageBirchColors = null;
    private static int[] swampFoliageColors = null;
    private static int[] swampGrassColors = null;
    private static int[][] blockPalettes = null;
    private static int[][] paletteColors = null;
    private static int[] skyColors = null;
    private static int[] fogColors = null;
    private static int[] underwaterColors = null;
    private static float[][][] lightMapsColorsRgb = null;
    private static int[] lightMapsHeight = null;
    private static float[][] sunRgbs = new float[16][3];
    private static float[][] torchRgbs = new float[16][3];
    private static int[] redstoneColors = null;
    private static int[] stemColors = null;
    private static int[] myceliumParticleColors = null;
    private static boolean useDefaultColorMultiplier = true;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static atc fogColorNether = null;
    private static atc fogColorEnd = null;
    private static atc skyColorEnd = null;
    private static final int TYPE_NONE = 0;
    private static final int TYPE_GRASS = 1;
    private static final int TYPE_FOLIAGE = 2;
    private static Random random = new Random();

    public static void update() {
        grassColors = null;
        waterColors = null;
        foliageColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        redstoneColors = null;
        stemColors = null;
        myceliumParticleColors = null;
        lightMapsColorsRgb = null;
        lightMapsHeight = null;
        lilyPadColor = -1;
        particleWaterColor = -1;
        particlePortalColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        blockPalettes = null;
        paletteColors = null;
        useDefaultColorMultiplier = true;
        String mcpColormap = "mcpatcher/colormap/";
        grassColors = CustomColorizer.getCustomColors("textures/colormap/grass.png", 65536);
        foliageColors = CustomColorizer.getCustomColors("textures/colormap/foliage.png", 65536);
        String[] waterPaths = new String[]{"water.png", "watercolorX.png"};
        waterColors = CustomColorizer.getCustomColors(mcpColormap, waterPaths, 65536);
        if (!Config.isCustomColors()) {
            return;
        }
        String[] pinePaths = new String[]{"pine.png", "pinecolor.png"};
        foliagePineColors = CustomColorizer.getCustomColors(mcpColormap, pinePaths, 65536);
        String[] birchPaths = new String[]{"birch.png", "birchcolor.png"};
        foliageBirchColors = CustomColorizer.getCustomColors(mcpColormap, birchPaths, 65536);
        String[] swampGrassPaths = new String[]{"swampgrass.png", "swampgrasscolor.png"};
        swampGrassColors = CustomColorizer.getCustomColors(mcpColormap, swampGrassPaths, 65536);
        String[] swampFoliagePaths = new String[]{"swampfoliage.png", "swampfoliagecolor.png"};
        swampFoliageColors = CustomColorizer.getCustomColors(mcpColormap, swampFoliagePaths, 65536);
        String[] sky0Paths = new String[]{"sky0.png", "skycolor0.png"};
        skyColors = CustomColorizer.getCustomColors(mcpColormap, sky0Paths, 65536);
        String[] fog0Paths = new String[]{"fog0.png", "fogcolor0.png"};
        fogColors = CustomColorizer.getCustomColors(mcpColormap, fog0Paths, 65536);
        String[] underwaterPaths = new String[]{"underwater.png", "underwatercolor.png"};
        underwaterColors = CustomColorizer.getCustomColors(mcpColormap, underwaterPaths, 65536);
        String[] redstonePaths = new String[]{"redstone.png", "redstonecolor.png"};
        redstoneColors = CustomColorizer.getCustomColors(mcpColormap, redstonePaths, 16);
        String[] stemPaths = new String[]{"stem.png", "stemcolor.png"};
        stemColors = CustomColorizer.getCustomColors(mcpColormap, stemPaths, 8);
        String[] myceliumPaths = new String[]{"myceliumparticle.png", "myceliumparticlecolor.png"};
        myceliumParticleColors = CustomColorizer.getCustomColors(mcpColormap, myceliumPaths, -1);
        int[][] lightMapsColors = new int[3][];
        lightMapsColorsRgb = new float[3][][];
        lightMapsHeight = new int[3];
        for (int i = 0; i < lightMapsColors.length; ++i) {
            String path = "mcpatcher/lightmap/world" + (i - 1) + ".png";
            lightMapsColors[i] = CustomColorizer.getCustomColors(path, -1);
            if (lightMapsColors[i] != null) {
                CustomColorizer.lightMapsColorsRgb[i] = CustomColorizer.toRgb(lightMapsColors[i]);
            }
            CustomColorizer.lightMapsHeight[i] = CustomColorizer.getTextureHeight(path, 32);
        }
        CustomColorizer.readColorProperties("mcpatcher/color.properties");
        CustomColorizer.updateUseDefaultColorMultiplier();
    }

    private static int getTextureHeight(String path, int defHeight) {
        try {
            InputStream in = Config.getResourceStream(new bjo(path));
            if (in == null) {
                return defHeight;
            }
            BufferedImage bi = ImageIO.read(in);
            if (bi == null) {
                return defHeight;
            }
            return bi.getHeight();
        }
        catch (IOException e) {
            return defHeight;
        }
    }

    private static float[][] toRgb(int[] cols) {
        float[][] colsRgb = new float[cols.length][3];
        for (int i = 0; i < cols.length; ++i) {
            int col = cols[i];
            float rf = (float)(col >> 16 & 0xFF) / 255.0f;
            float gf = (float)(col >> 8 & 0xFF) / 255.0f;
            float bf = (float)(col & 0xFF) / 255.0f;
            float[] colRgb = colsRgb[i];
            colRgb[0] = rf;
            colRgb[1] = gf;
            colRgb[2] = bf;
        }
        return colsRgb;
    }

    private static void readColorProperties(String fileName) {
        try {
            bjo loc = new bjo(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            Config.log("Loading " + fileName);
            Properties props = new Properties();
            props.load(in);
            lilyPadColor = CustomColorizer.readColor(props, "lilypad");
            particleWaterColor = CustomColorizer.readColor(props, new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColorizer.readColor(props, "particle.portal");
            fogColorNether = CustomColorizer.readColorVec3(props, "fog.nether");
            fogColorEnd = CustomColorizer.readColorVec3(props, "fog.end");
            skyColorEnd = CustomColorizer.readColorVec3(props, "sky.end");
            CustomColorizer.readCustomPalettes(props, fileName);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void readCustomPalettes(Properties props, String fileName) {
        void var6_9;
        blockPalettes = new int[256][1];
        for (int i = 0; i < 256; ++i) {
            CustomColorizer.blockPalettes[i][0] = -1;
        }
        String palettePrefix = "palette.block.";
        HashMap<String, String> map = new HashMap<String, String>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(palettePrefix)) continue;
            map.put(string, value);
        }
        String[] propNames = map.keySet().toArray(new String[map.size()]);
        paletteColors = new int[propNames.length][];
        boolean bl = false;
        while (var6_9 < propNames.length) {
            String name = propNames[var6_9];
            String value = props.getProperty(name);
            Config.log("Block palette: " + name + " = " + value);
            String path = name.substring(palettePrefix.length());
            String basePath = TextureUtils.getBasePath(fileName);
            path = TextureUtils.fixResourcePath(path, basePath);
            int[] colors = CustomColorizer.getCustomColors(path, 65536);
            CustomColorizer.paletteColors[var6_9] = colors;
            String[] indexStrs = Config.tokenize(value, " ,;");
            for (int ix = 0; ix < indexStrs.length; ++ix) {
                int blockIndex;
                String blockStr = indexStrs[ix];
                int metadata = -1;
                if (blockStr.contains(":")) {
                    String[] blockStrs = Config.tokenize(blockStr, ":");
                    blockStr = blockStrs[0];
                    String metadataStr = blockStrs[1];
                    metadata = Config.parseInt(metadataStr, -1);
                    if (metadata < 0 || metadata > 15) {
                        Config.log("Invalid block metadata: " + blockStr + " in palette: " + name);
                        continue;
                    }
                }
                if ((blockIndex = Config.parseInt(blockStr, -1)) < 0 || blockIndex > 255) {
                    Config.log("Invalid block index: " + blockIndex + " in palette: " + name);
                    continue;
                }
                if (blockIndex == aqz.z.cF || blockIndex == aqz.ac.cF || blockIndex == aqz.P.cF || blockIndex == aqz.bz.cF) continue;
                if (metadata == -1) {
                    CustomColorizer.blockPalettes[blockIndex][0] = var6_9;
                    continue;
                }
                if (blockPalettes[blockIndex].length < 16) {
                    CustomColorizer.blockPalettes[blockIndex] = new int[16];
                    Arrays.fill(blockPalettes[blockIndex], -1);
                }
                CustomColorizer.blockPalettes[blockIndex][metadata] = var6_9;
            }
            ++var6_9;
        }
    }

    private static int readColor(Properties props, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int col = CustomColorizer.readColor(props, name);
            if (col < 0) continue;
            return col;
        }
        return -1;
    }

    private static int readColor(Properties props, String name) {
        String str = props.getProperty(name);
        if (str == null) {
            return -1;
        }
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            Config.log("Custom color: " + name + " = " + str);
            return val;
        }
        catch (NumberFormatException e) {
            Config.log("Invalid custom color: " + name + " = " + str);
            return -1;
        }
    }

    private static atc readColorVec3(Properties props, String name) {
        int col = CustomColorizer.readColor(props, name);
        if (col < 0) {
            return null;
        }
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        return atc.a((double)redF, (double)greenF, (double)blueF);
    }

    private static int[] getCustomColors(String basePath, String[] paths, int length) {
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            path = basePath + path;
            int[] cols = CustomColorizer.getCustomColors(path, length);
            if (cols == null) continue;
            return cols;
        }
        return null;
    }

    private static int[] getCustomColors(String path, int length) {
        try {
            bjo loc = new bjo(path);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return null;
            }
            int[] colors = bip.a((bjp)Config.getResourceManager(), (bjo)loc);
            if (colors == null) {
                return null;
            }
            if (length > 0 && colors.length != length) {
                Config.log("Invalid custom colors length: " + colors.length + ", path: " + path);
                return null;
            }
            Config.log("Loading custom colors: " + path);
            return colors;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateUseDefaultColorMultiplier() {
        useDefaultColorMultiplier = foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null && blockPalettes == null && Config.isSwampColors() && Config.isSmoothBiomes();
    }

    public static int getColorMultiplier(aqz block, acf blockAccess, int x2, int y, int z) {
        int metadata;
        if (useDefaultColorMultiplier) {
            return block.c(blockAccess, x2, y, z);
        }
        int[] colors = null;
        int[] swampColors = null;
        if (blockPalettes != null) {
            int blockId = block.cF;
            if (blockId >= 0 && blockId < 256) {
                int[] metadataPals = blockPalettes[blockId];
                int paletteIx = -1;
                if (metadataPals.length > 1) {
                    metadata = blockAccess.h(x2, y, z);
                    paletteIx = metadataPals[metadata];
                } else {
                    paletteIx = metadataPals[0];
                }
                if (paletteIx >= 0) {
                    colors = paletteColors[paletteIx];
                }
            }
            if (colors != null) {
                if (Config.isSmoothBiomes()) {
                    return CustomColorizer.getSmoothColorMultiplier(block, blockAccess, x2, y, z, colors, colors, 0, 0);
                }
                return CustomColorizer.getCustomColor(colors, blockAccess, x2, y, z);
            }
        }
        boolean useSwampColors = Config.isSwampColors();
        boolean smoothColors = false;
        int type = 0;
        metadata = 0;
        if (block == aqz.z || block == aqz.ac) {
            type = 1;
            smoothColors = Config.isSmoothBiomes();
            colors = grassColors;
            swampColors = useSwampColors ? swampGrassColors : colors;
        } else if (block == aqz.P) {
            type = 2;
            smoothColors = Config.isSmoothBiomes();
            metadata = blockAccess.h(x2, y, z);
            if ((metadata & 3) == 1) {
                colors = foliagePineColors;
            } else if ((metadata & 3) == 2) {
                colors = foliageBirchColors;
            } else {
                colors = foliageColors;
                swampColors = useSwampColors ? swampFoliageColors : colors;
            }
        } else if (block == aqz.bz) {
            type = 2;
            smoothColors = Config.isSmoothBiomes();
            colors = foliageColors;
            swampColors = useSwampColors ? swampFoliageColors : colors;
        }
        if (smoothColors) {
            return CustomColorizer.getSmoothColorMultiplier(block, blockAccess, x2, y, z, colors, swampColors, type, metadata);
        }
        if (swampColors != colors && blockAccess.a(x2, z) == acq.h) {
            colors = swampColors;
        }
        if (colors != null) {
            return CustomColorizer.getCustomColor(colors, blockAccess, x2, y, z);
        }
        return block.c(blockAccess, x2, y, z);
    }

    private static int getSmoothColorMultiplier(aqz block, acf blockAccess, int x2, int y, int z, int[] colors, int[] swampColors, int type, int metadata) {
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        for (int ix = x2 - 1; ix <= x2 + 1; ++ix) {
            for (int iz = z - 1; iz <= z + 1; ++iz) {
                int[] cols = colors;
                if (swampColors != cols && blockAccess.a(ix, iz) == acq.h) {
                    cols = swampColors;
                }
                int col = 0;
                if (cols == null) {
                    switch (type) {
                        case 1: {
                            col = blockAccess.a(ix, iz).k();
                            break;
                        }
                        case 2: {
                            if ((metadata & 3) == 1) {
                                col = abs.a();
                                break;
                            }
                            if ((metadata & 3) == 2) {
                                col = abs.b();
                                break;
                            }
                            col = blockAccess.a(ix, iz).l();
                            break;
                        }
                        default: {
                            col = block.c(blockAccess, ix, y, iz);
                            break;
                        }
                    }
                } else {
                    col = CustomColorizer.getCustomColor(cols, blockAccess, ix, y, iz);
                }
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
            }
        }
        int r2 = sumRed / 9;
        int g = sumGreen / 9;
        int b2 = sumBlue / 9;
        return r2 << 16 | g << 8 | b2;
    }

    public static int getFluidColor(aqz block, acf blockAccess, int x2, int y, int z) {
        if (block.cU != akc.h) {
            return block.c(blockAccess, x2, y, z);
        }
        if (waterColors != null) {
            if (Config.isSmoothBiomes()) {
                return CustomColorizer.getSmoothColor(waterColors, blockAccess, x2, y, z, 3, 1);
            }
            return CustomColorizer.getCustomColor(waterColors, blockAccess, x2, y, z);
        }
        if (!Config.isSwampColors()) {
            return 0xFFFFFF;
        }
        return block.c(blockAccess, x2, y, z);
    }

    private static int getCustomColor(int[] colors, acf blockAccess, int x2, int y, int z) {
        acq bgb = blockAccess.a(x2, z);
        double temperature = ls.a((float)bgb.j(), (float)0.0f, (float)1.0f);
        double rainfall = ls.a((float)bgb.i(), (float)0.0f, (float)1.0f);
        int cx = (int)((1.0 - temperature) * 255.0);
        int cy = (int)((1.0 - (rainfall *= temperature)) * 255.0);
        return colors[cy << 8 | cx] & 0xFFFFFF;
    }

    public static void updatePortalFX(beg fx) {
        if (particlePortalColor < 0) {
            return;
        }
        int col = particlePortalColor;
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.j = redF;
        fx.au = greenF;
        fx.av = blueF;
    }

    public static void updateMyceliumFX(beg fx) {
        if (myceliumParticleColors == null) {
            return;
        }
        int col = myceliumParticleColors[random.nextInt(myceliumParticleColors.length)];
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.j = redF;
        fx.au = greenF;
        fx.av = blueF;
    }

    public static void updateReddustFX(beg fx, acf blockAccess, double x2, double y, double z) {
        if (redstoneColors == null) {
            return;
        }
        int level = blockAccess.h((int)x2, (int)y, (int)z);
        int col = CustomColorizer.getRedstoneColor(level);
        if (col == -1) {
            return;
        }
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.j = redF;
        fx.au = greenF;
        fx.av = blueF;
    }

    public static int getRedstoneColor(int level) {
        if (redstoneColors == null) {
            return -1;
        }
        if (level < 0 || level > 15) {
            return -1;
        }
        return redstoneColors[level] & 0xFFFFFF;
    }

    public static void updateWaterFX(beg fx, acf blockAccess) {
        if (waterColors == null) {
            return;
        }
        int x2 = (int)fx.u;
        int y = (int)fx.v;
        int z = (int)fx.w;
        int col = CustomColorizer.getFluidColor(aqz.G, blockAccess, x2, y, z);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        if (particleWaterColor >= 0) {
            int redDrop = particleWaterColor >> 16 & 0xFF;
            int greenDrop = particleWaterColor >> 8 & 0xFF;
            int blueDrop = particleWaterColor & 0xFF;
            redF *= (float)redDrop / 255.0f;
            greenF *= (float)greenDrop / 255.0f;
            blueF *= (float)blueDrop / 255.0f;
        }
        fx.j = redF;
        fx.au = greenF;
        fx.av = blueF;
    }

    public static int getLilypadColor() {
        if (lilyPadColor < 0) {
            return aqz.bE.o();
        }
        return lilyPadColor;
    }

    public static atc getFogColorNether(atc col) {
        if (fogColorNether == null) {
            return col;
        }
        return fogColorNether;
    }

    public static atc getFogColorEnd(atc col) {
        if (fogColorEnd == null) {
            return col;
        }
        return fogColorEnd;
    }

    public static atc getSkyColorEnd(atc col) {
        if (skyColorEnd == null) {
            return col;
        }
        return skyColorEnd;
    }

    public static atc getSkyColor(atc skyColor3d, acf blockAccess, double x2, double y, double z) {
        if (skyColors == null) {
            return skyColor3d;
        }
        int col = CustomColorizer.getSmoothColor(skyColors, blockAccess, x2, y, z, 10, 1);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)skyColor3d.c / 0.5f;
        float cGreen = (float)skyColor3d.d / 0.66275f;
        float cBlue = (float)skyColor3d.e;
        return atc.a((double)(redF *= cRed), (double)(greenF *= cGreen), (double)(blueF *= cBlue));
    }

    public static atc getFogColor(atc fogColor3d, acf blockAccess, double x2, double y, double z) {
        if (fogColors == null) {
            return fogColor3d;
        }
        int col = CustomColorizer.getSmoothColor(fogColors, blockAccess, x2, y, z, 10, 1);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)fogColor3d.c / 0.753f;
        float cGreen = (float)fogColor3d.d / 0.8471f;
        float cBlue = (float)fogColor3d.e;
        return atc.a((double)(redF *= cRed), (double)(greenF *= cGreen), (double)(blueF *= cBlue));
    }

    public static atc getUnderwaterColor(acf blockAccess, double x2, double y, double z) {
        if (underwaterColors == null) {
            return null;
        }
        int col = CustomColorizer.getSmoothColor(underwaterColors, blockAccess, x2, y, z, 10, 1);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        return atc.a((double)redF, (double)greenF, (double)blueF);
    }

    public static int getSmoothColor(int[] colors, acf blockAccess, double x2, double y, double z, int samples, int step) {
        if (colors == null) {
            return -1;
        }
        int x0 = (int)Math.floor(x2);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        int n = samples * step / 2;
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        int count = 0;
        for (int ix = x0 - n; ix <= x0 + n; ix += step) {
            for (int iz = z0 - n; iz <= z0 + n; iz += step) {
                int col = CustomColorizer.getCustomColor(colors, blockAccess, ix, y0, iz);
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
                ++count;
            }
        }
        int r2 = sumRed / count;
        int g = sumGreen / count;
        int b2 = sumBlue / count;
        return r2 << 16 | g << 8 | b2;
    }

    public static int mixColors(int c1, int c2, float w1) {
        if (w1 <= 0.0f) {
            return c2;
        }
        if (w1 >= 1.0f) {
            return c1;
        }
        float w2 = 1.0f - w1;
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r3 = (int)((float)r1 * w1 + (float)r2 * w2);
        int g = (int)((float)g1 * w1 + (float)g2 * w2);
        int b3 = (int)((float)b1 * w1 + (float)b2 * w2);
        return r3 << 16 | g << 8 | b3;
    }

    private static int averageColor(int c1, int c2) {
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r3 = (r1 + r2) / 2;
        int g = (g1 + g2) / 2;
        int b3 = (b1 + b2) / 2;
        return r3 << 16 | g << 8 | b3;
    }

    public static int getStemColorMultiplier(aqq blockStem, acf blockAccess, int x2, int y, int z) {
        if (stemColors == null) {
            return blockStem.c(blockAccess, x2, y, z);
        }
        int level = blockAccess.h(x2, y, z);
        if (level < 0) {
            level = 0;
        }
        if (level >= stemColors.length) {
            level = stemColors.length - 1;
        }
        return stemColors[level];
    }

    public static boolean updateLightmap(abw world, bfe entityRenderer, int[] lmColors, boolean nightvision) {
        if (world == null) {
            return false;
        }
        if (lightMapsColorsRgb == null) {
            return false;
        }
        if (!Config.isCustomColors()) {
            return false;
        }
        int worldType = world.t.i;
        if (worldType < -1 || worldType > 1) {
            return false;
        }
        int lightMapIndex = worldType + 1;
        float[][] lightMapRgb = lightMapsColorsRgb[lightMapIndex];
        if (lightMapRgb == null) {
            return false;
        }
        int height = lightMapsHeight[lightMapIndex];
        if (nightvision && height < 64) {
            return false;
        }
        int width = lightMapRgb.length / height;
        if (width < 16) {
            Config.warn("Invalid lightmap width: " + width + " for: /environment/lightmap" + worldType + ".png");
            CustomColorizer.lightMapsColorsRgb[lightMapIndex] = null;
            return false;
        }
        int startIndex = 0;
        if (nightvision) {
            startIndex = width * 16 * 2;
        }
        float sun = 1.1666666f * (world.b(1.0f) - 0.2f);
        if (world.q > 0) {
            sun = 1.0f;
        }
        sun = Config.limitTo1(sun);
        float sunX = sun * (float)(width - 1);
        float torchX = Config.limitTo1(entityRenderer.d + 0.5f) * (float)(width - 1);
        float gamma = Config.limitTo1(Config.getGameSettings().ak);
        boolean hasGamma = gamma > 1.0E-4f;
        CustomColorizer.getLightMapColumn(lightMapRgb, sunX, startIndex, width, sunRgbs);
        CustomColorizer.getLightMapColumn(lightMapRgb, torchX, startIndex + 16 * width, width, torchRgbs);
        float[] rgb = new float[3];
        for (int is = 0; is < 16; ++is) {
            for (int it = 0; it < 16; ++it) {
                for (int ic = 0; ic < 3; ++ic) {
                    float comp = Config.limitTo1(sunRgbs[is][ic] + torchRgbs[it][ic]);
                    if (hasGamma) {
                        float cg = 1.0f - comp;
                        cg = 1.0f - cg * cg * cg * cg;
                        comp = gamma * cg + (1.0f - gamma) * comp;
                    }
                    rgb[ic] = comp;
                }
                int r2 = (int)(rgb[0] * 255.0f);
                int g = (int)(rgb[1] * 255.0f);
                int b2 = (int)(rgb[2] * 255.0f);
                lmColors[is * 16 + it] = 0xFF000000 | r2 << 16 | g << 8 | b2;
            }
        }
        return true;
    }

    private static void getLightMapColumn(float[][] origMap, float x2, int offset, int width, float[][] colRgb) {
        int xHigh;
        int xLow = (int)Math.floor(x2);
        if (xLow == (xHigh = (int)Math.ceil(x2))) {
            for (int y = 0; y < 16; ++y) {
                float[] rgbLow = origMap[offset + y * width + xLow];
                float[] rgb = colRgb[y];
                for (int i = 0; i < 3; ++i) {
                    rgb[i] = rgbLow[i];
                }
            }
            return;
        }
        float dLow = 1.0f - (x2 - (float)xLow);
        float dHigh = 1.0f - ((float)xHigh - x2);
        for (int y = 0; y < 16; ++y) {
            float[] rgbLow = origMap[offset + y * width + xLow];
            float[] rgbHigh = origMap[offset + y * width + xHigh];
            float[] rgb = colRgb[y];
            for (int i = 0; i < 3; ++i) {
                rgb[i] = rgbLow[i] * dLow + rgbHigh[i] * dHigh;
            }
        }
    }
}

