/* * * * * * * * * * * * * * * * * * * * * * * *
 *    Admin_radar, by BlueRaja (AMX Mod X)     *
 *                                             *
 *      Special thanks to Damaged Soul         *
 * - not just for helping me when I needed it, *
 *    but for putting up with all my shit ^_^  *
 *                                             *
 *          (c) Copyright 2004                 *
 * This file is provided as is (no warranties) *
 * * * * * * * * * * * * * * * * * * * * * * * */


//Includes
#include <amxmodx>
#include <cstrike> //used for cs_get_user_team

//Defines
#define ACCESS_LEVEL ADMIN_RCON //Default required admin level - don't want too many admins to have it, for the sake of speed
#define REFRESH_TIME 1.0        //Amount of time, in seconds, between radar-refreshings

//Messages
new gmsgBombDrop		//Dropping of the bomb
new gmsgHostagePos	//Position of hostage(s)
new gmsgHostageK		//Hostage has been killed

//Globals
new g_aAdminList[32], g_iAdminNum
new g_aCTList[32], g_iCTNum
new g_aTList[32], g_iTNum
new g_iEnemyCounter, g_iHostageCounter //Both are used for keeping track of the enemy
new g_iHostageModNum //Number with which to modulus hostage number; used to,
                     //if there are less than 4 T's, kill a fake-hostage blip.
new bool:g_bBombHeld

//Refreshes the list of admins
public refresh_admin()
{
	new aTemp[32], iTempNum
	get_players(aTemp, iTempNum, "c")//Skip bots

	g_iAdminNum=0
	for (new i=0; i<iTempNum; i++) {
		if (get_user_flags(aTemp[i])&ACCESS_LEVEL) {
			g_aAdminList[g_iAdminNum]=aTemp[i]
			g_iAdminNum++
		}//end if
	}//end for
	return PLUGIN_HANDLED
}//end refresh_admin

//Refresh list of terrorists
public refresh_t() {
	get_players(g_aTList, g_iTNum, "ae", "TERRORIST")
	if (g_iTNum<4 && g_iHostageModNum!=g_iTNum) {
		g_iHostageModNum=g_iTNum //Only modulus with this number now

		//If there are three players left, then we want to fake-kill the fourth fake-hostage,
		//so that there aren't two blips on the radar for one player
		for(new i=0; i<g_iAdminNum; i++) {
			if (cs_get_user_team(g_aAdminList[i])==CS_TEAM_CT) {
				message_begin(MSG_ONE, gmsgHostageK, {0,0,0}, g_aAdminList[i])
				write_byte(g_iTNum+1)	//Hostage to take off of radar
				message_end()
			}//end if
		}//end for
	}//end if
}//end refresh_t()

//Refresh list of CT's
#define refresh_ct() get_players(g_aCTList, g_iCTNum, "ae", "CT")
	//I wanted the above to be an inline function, but I don't think Small supports that,
	// so I used a macro instead

//This function will be called every second; it should display a single blip for a certain player
public radar_event(id)
{
	if(!g_iAdminNum || !g_iCTNum || !g_iTNum) return PLUGIN_HANDLED

	new iEnemyT = g_aTList[g_iEnemyCounter%g_iTNum] //Cycle through the living Ts
	new iCoordsT[3]
	get_user_origin(iEnemyT, iCoordsT)

	new iEnemyCT = g_aCTList[g_iEnemyCounter++%g_iCTNum]
	new iCoordsCT[3]
	get_user_origin(iEnemyCT, iCoordsCT)

	new iHostageNum = (g_iHostageCounter++)%g_iHostageModNum + 1

	for(new i=0; i<g_iAdminNum; i++)
	{
		//At this point, we know we want to send the message to the admin
		if (cs_get_user_team(g_aAdminList[i])==CS_TEAM_T) {			
			if (g_bBombHeld) { //If bomb is on the ground, the admins need to see it on their radar
				message_begin(MSG_ONE, gmsgBombDrop, {0,0,0}, g_aAdminList[i])
				write_coord(iCoordsCT[0])	//X Coordinate
				write_coord(iCoordsCT[1])	//Y Coordinate
				write_coord(iCoordsCT[2])	//Z Coordinate
				write_byte(0)			//?? This byte seems to always be 0...so, w/e
				message_end()
			}
		} 
		else { //assume player is CT
			message_begin(MSG_ONE, gmsgHostagePos, {0,0,0}, g_aAdminList[i])
			write_byte(1)			//No idea what this byte does; I think it has something to do with whether or not the hostage is following someone
			write_byte(iHostageNum)		//The number of the hostage, 1-4
			write_coord(iCoordsT[0])	//X Coordinate
			write_coord(iCoordsT[1])	//Y Coordinate
			write_coord(iCoordsT[2])	//Z Coordinate
			message_end()
		}//end if
	}//end for
	return PLUGIN_HANDLED
}//end radar_event

//Called at round start
public RoundStart()
{
	new Float:fRoundTime = get_cvar_float("mp_roundtime") * 60.0
	new iTimeLeft = read_data(1)

	if (fRoundTime == iTimeLeft) { //Roundstart after freezetime
		g_iHostageCounter = 0
		g_iEnemyCounter   = 0
		g_iHostageModNum  = 4
		g_bBombHeld       = true
		refresh_t()
		refresh_ct()

		//The hostage "killed" is only #(g_iTNum+1); however, apparently when the engine receieves a HostagePos message,
		//It assumes there are four hostages.  Therefore, when playing with less than three people, the hostages not represented
		//by players and not yet killed are set, by default, at the center of the map.  To fix this, I'll have to kill hostage #4
		//(if there are two players) or hostages #3 & #4 (if there is only one player)
		if (g_iTNum<3) {
			for (new i=g_iTNum+2; i<=4; i++) {
				for(new j=0; j<g_iAdminNum; j++) {
					message_begin(MSG_ONE, gmsgHostageK, {0,0,0}, g_aAdminList[j])
					write_byte(i)	//Hostage to take off of radar
					message_end()
				}//end for
			}//end for
		}//end if
	}//end if
	return PLUGIN_CONTINUE
}//end RoundStart

//Initialization
public plugin_init()
{
	gmsgBombDrop   = get_user_msgid("BombDrop")
	gmsgHostagePos = get_user_msgid("HostagePos")
	gmsgHostageK   = get_user_msgid("HostageK")
	register_event("RoundTime", "RoundStart", "bc")
	register_event("BombDrop", "Bomb_Drop", "bc")
	register_event("BombPickup", "Bomb_Pickup", "bc")
	register_plugin("Admin Radar","1.1","BlueRaja")
	register_concmd("amx_refresh","refresh_admin",ACCESS_LEVEL," - refresh admin slots(adminradar)")
	set_task(REFRESH_TIME, "radar_event", _, _, _, "b")
	return PLUGIN_CONTINUE
}

//refresh list on client connect/disconnect
public client_authorized(id)
{
	refresh_admin()
}
public client_disconnect(id)
{
	refresh_admin()
	refresh_t()
	refresh_ct()
}

//Refresh list of players on client death
public client_kill(id)//Called when a player kills himself
{
	if (cs_get_user_team(id)==CS_TEAM_T) {
		refresh_t()
	}
	else{
		refresh_ct()
	}
}

public client_death(killer, victim, weapon, hitplace, TK) //Called when a player dies
{
	if (cs_get_user_team(victim)==CS_TEAM_T) {
		refresh_t()
	}
	else{
		refresh_ct()
	}
}

public Bomb_Drop()
{
	g_bBombHeld = false
}

public Bomb_Pickup()
{
	g_bBombHeld = true
}