#include <amxmodx>
#include <engine>

#pragma semicolon 1

#define UPDATE_TIME	1.0
#define ENTITY_CLASS	"env_host_timeleft"

new bool:g_timerRunning = false;
new g_MsgServerName;
new g_szHostname[ 64 ];
new g_pointerTimelimit;
new g_pointerHostname;
new g_cvarEnabled;
new g_cvarStyle;

public plugin_init() {
	register_plugin( "Time Score", "1.1", "OverGame" );
	
	g_cvarEnabled		= register_cvar( "sv_TimeScore_timeleft", "1" );
	g_cvarStyle			= register_cvar( "sv_TimeScore_style", "3" );
	g_pointerTimelimit	= get_cvar_pointer( "mp_timelimit" );
	g_pointerHostname	= get_cvar_pointer( "hostname" );
	
	g_MsgServerName		= get_user_msgid( "ServerName" );
	
	set_task( 2.5, "checkTimeleft" );
}

public plugin_end( )
	if( g_timerRunning )
		if( strlen( g_szHostname ) )
			set_pcvar_string( g_pointerHostname, g_szHostname );

public checkTimeleft( ) {
	get_pcvar_string( g_pointerHostname, g_szHostname, 63 );
	
	if( get_pcvar_num( g_cvarEnabled ) != 1 ) {
		g_timerRunning = false;
		
		return;
	} else
		register_think( ENTITY_CLASS, "fwdThink_Updater" );
	
	g_timerRunning = true;
	
	new iEntityTimer = create_entity( "info_target" );
	entity_set_string( iEntityTimer, EV_SZ_classname, ENTITY_CLASS );
	entity_set_float( iEntityTimer, EV_FL_nextthink, get_gametime() + UPDATE_TIME );
}

public fwdThink_Updater( iEntity ) {
	static szHostname[ 64 ], iStyle;
	iStyle = get_pcvar_num( g_cvarStyle );
	
	if( get_pcvar_float( g_pointerTimelimit ) ) {
		static iHours, iMinutes, iSeconds;
		
		iSeconds	= get_timeleft( );
		iMinutes	= iSeconds / 60;
		iHours		= iMinutes / 60;
		iSeconds	= iSeconds - iMinutes * 60;
		iMinutes	= iMinutes - iHours * 60;
		
		
		if( iHours ) {
			switch( iStyle ) {
				case 1: formatex( szHostname, 63, "%s (Время %d:%02d:%02d)", g_szHostname, iHours, iMinutes, iSeconds );
				case 2: formatex( szHostname, 63, "%s (%d:%02d:%02d)", g_szHostname, iHours, iMinutes, iSeconds );
				case 3: formatex( szHostname, 63, "(%d:%02d:%02d) %s", iHours, iMinutes, iSeconds, g_szHostname );
			}
		} else {
			switch( iStyle ) {
				case 1: formatex( szHostname, 63, "%s (Время %d:%02d)", g_szHostname, iMinutes, iSeconds );
				case 2: formatex( szHostname, 63, "%s (%d:%02d)", g_szHostname, iMinutes, iSeconds );
				case 3: formatex( szHostname, 63, "(%d:%02d) %s", iMinutes, iSeconds, g_szHostname );
			}
		}
	} else {
		switch( iStyle ) {
			case 1: formatex( szHostname, 63, "%s (Время не настроено)", g_szHostname );
			case 2: formatex( szHostname, 63, "%s (--:--)", g_szHostname );
			case 3: formatex( szHostname, 63, "(Время: --:--) %s by OverGame", g_szHostname );
		}
	}
	
	set_pcvar_string( g_pointerHostname, szHostname );
	
	message_begin( MSG_BROADCAST, g_MsgServerName );
	write_string( szHostname );
	message_end( );
	
	entity_set_float( iEntity, EV_FL_nextthink, get_gametime() + UPDATE_TIME );
	
	return PLUGIN_CONTINUE;
}